/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.PoseMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the pose of the face as determined by its pitch, roll, and yaw.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Pose implements StructuredPojo, ToCopyableBuilder<Pose.Builder, Pose> {
    private final Float roll;

    private final Float yaw;

    private final Float pitch;

    private Pose(BuilderImpl builder) {
        this.roll = builder.roll;
        this.yaw = builder.yaw;
        this.pitch = builder.pitch;
    }

    /**
     * <p>
     * Value representing the face rotation on the roll axis.
     * </p>
     * 
     * @return Value representing the face rotation on the roll axis.
     */
    public Float roll() {
        return roll;
    }

    /**
     * <p>
     * Value representing the face rotation on the yaw axis.
     * </p>
     * 
     * @return Value representing the face rotation on the yaw axis.
     */
    public Float yaw() {
        return yaw;
    }

    /**
     * <p>
     * Value representing the face rotation on the pitch axis.
     * </p>
     * 
     * @return Value representing the face rotation on the pitch axis.
     */
    public Float pitch() {
        return pitch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roll());
        hashCode = 31 * hashCode + Objects.hashCode(yaw());
        hashCode = 31 * hashCode + Objects.hashCode(pitch());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pose)) {
            return false;
        }
        Pose other = (Pose) obj;
        return Objects.equals(roll(), other.roll()) && Objects.equals(yaw(), other.yaw())
                && Objects.equals(pitch(), other.pitch());
    }

    @Override
    public String toString() {
        return ToString.builder("Pose").add("Roll", roll()).add("Yaw", yaw()).add("Pitch", pitch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Roll":
            return Optional.of(clazz.cast(roll()));
        case "Yaw":
            return Optional.of(clazz.cast(yaw()));
        case "Pitch":
            return Optional.of(clazz.cast(pitch()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PoseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Pose> {
        /**
         * <p>
         * Value representing the face rotation on the roll axis.
         * </p>
         * 
         * @param roll
         *        Value representing the face rotation on the roll axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roll(Float roll);

        /**
         * <p>
         * Value representing the face rotation on the yaw axis.
         * </p>
         * 
         * @param yaw
         *        Value representing the face rotation on the yaw axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yaw(Float yaw);

        /**
         * <p>
         * Value representing the face rotation on the pitch axis.
         * </p>
         * 
         * @param pitch
         *        Value representing the face rotation on the pitch axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pitch(Float pitch);
    }

    static final class BuilderImpl implements Builder {
        private Float roll;

        private Float yaw;

        private Float pitch;

        private BuilderImpl() {
        }

        private BuilderImpl(Pose model) {
            roll(model.roll);
            yaw(model.yaw);
            pitch(model.pitch);
        }

        public final Float getRoll() {
            return roll;
        }

        @Override
        public final Builder roll(Float roll) {
            this.roll = roll;
            return this;
        }

        public final void setRoll(Float roll) {
            this.roll = roll;
        }

        public final Float getYaw() {
            return yaw;
        }

        @Override
        public final Builder yaw(Float yaw) {
            this.yaw = yaw;
            return this;
        }

        public final void setYaw(Float yaw) {
            this.yaw = yaw;
        }

        public final Float getPitch() {
            return pitch;
        }

        @Override
        public final Builder pitch(Float pitch) {
            this.pitch = pitch;
            return this;
        }

        public final void setPitch(Float pitch) {
            this.pitch = pitch;
        }

        @Override
        public Pose build() {
            return new Pose(this);
        }
    }
}
