/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetectModerationLabelsResponse extends RekognitionResponse implements
        ToCopyableBuilder<DetectModerationLabelsResponse.Builder, DetectModerationLabelsResponse> {
    private final List<ModerationLabel> moderationLabels;

    private DetectModerationLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.moderationLabels = builder.moderationLabels;
    }

    /**
     * <p>
     * An array of labels for explicit or suggestive adult content found in the image. The list includes the top-level
     * label and each child label detected in the image. This is useful for filtering specific categories of content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of labels for explicit or suggestive adult content found in the image. The list includes the
     *         top-level label and each child label detected in the image. This is useful for filtering specific
     *         categories of content.
     */
    public List<ModerationLabel> moderationLabels() {
        return moderationLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moderationLabels());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsResponse)) {
            return false;
        }
        DetectModerationLabelsResponse other = (DetectModerationLabelsResponse) obj;
        return Objects.equals(moderationLabels(), other.moderationLabels());
    }

    @Override
    public String toString() {
        return ToString.builder("DetectModerationLabelsResponse").add("ModerationLabels", moderationLabels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModerationLabels":
            return Optional.of(clazz.cast(moderationLabels()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends RekognitionResponse.Builder, CopyableBuilder<Builder, DetectModerationLabelsResponse> {
        /**
         * <p>
         * An array of labels for explicit or suggestive adult content found in the image. The list includes the
         * top-level label and each child label detected in the image. This is useful for filtering specific categories
         * of content.
         * </p>
         * 
         * @param moderationLabels
         *        An array of labels for explicit or suggestive adult content found in the image. The list includes the
         *        top-level label and each child label detected in the image. This is useful for filtering specific
         *        categories of content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(Collection<ModerationLabel> moderationLabels);

        /**
         * <p>
         * An array of labels for explicit or suggestive adult content found in the image. The list includes the
         * top-level label and each child label detected in the image. This is useful for filtering specific categories
         * of content.
         * </p>
         * 
         * @param moderationLabels
         *        An array of labels for explicit or suggestive adult content found in the image. The list includes the
         *        top-level label and each child label detected in the image. This is useful for filtering specific
         *        categories of content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moderationLabels(ModerationLabel... moderationLabels);
    }

    static final class BuilderImpl extends RekognitionResponse.BuilderImpl implements Builder {
        private List<ModerationLabel> moderationLabels;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsResponse model) {
            moderationLabels(model.moderationLabels);
        }

        public final Collection<ModerationLabel.Builder> getModerationLabels() {
            return moderationLabels != null ? moderationLabels.stream().map(ModerationLabel::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder moderationLabels(Collection<ModerationLabel> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copy(moderationLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder moderationLabels(ModerationLabel... moderationLabels) {
            moderationLabels(Arrays.asList(moderationLabels));
            return this;
        }

        public final void setModerationLabels(Collection<ModerationLabel.BuilderImpl> moderationLabels) {
            this.moderationLabels = ModerationLabelsCopier.copyFromBuilder(moderationLabels);
        }

        @Override
        public DetectModerationLabelsResponse build() {
            return new DetectModerationLabelsResponse(this);
        }
    }
}
