/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchFacesByImageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SearchFacesByImageRequest> {
    private final String collectionId;
    private final Image image;
    private final Integer maxFaces;
    private final Float faceMatchThreshold;

    private SearchFacesByImageRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.maxFaces = builder.maxFaces;
        this.faceMatchThreshold = builder.faceMatchThreshold;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public Image image() {
        return this.image;
    }

    public Integer maxFaces() {
        return this.maxFaces;
    }

    public Float faceMatchThreshold() {
        return this.faceMatchThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.collectionId() == null ? 0 : this.collectionId().hashCode());
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.maxFaces() == null ? 0 : this.maxFaces().hashCode());
        hashCode = 31 * hashCode + (this.faceMatchThreshold() == null ? 0 : this.faceMatchThreshold().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesByImageRequest)) {
            return false;
        }
        SearchFacesByImageRequest other = (SearchFacesByImageRequest)((Object)obj);
        if (other.collectionId() == null ^ this.collectionId() == null) {
            return false;
        }
        if (other.collectionId() != null && !other.collectionId().equals(this.collectionId())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.maxFaces() == null ^ this.maxFaces() == null) {
            return false;
        }
        if (other.maxFaces() != null && !other.maxFaces().equals(this.maxFaces())) {
            return false;
        }
        if (other.faceMatchThreshold() == null ^ this.faceMatchThreshold() == null) {
            return false;
        }
        return other.faceMatchThreshold() == null || other.faceMatchThreshold().equals(this.faceMatchThreshold());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.collectionId() != null) {
            sb.append("CollectionId: ").append(this.collectionId()).append(",");
        }
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.maxFaces() != null) {
            sb.append("MaxFaces: ").append(this.maxFaces()).append(",");
        }
        if (this.faceMatchThreshold() != null) {
            sb.append("FaceMatchThreshold: ").append(this.faceMatchThreshold()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.of(clazz.cast(this.collectionId()));
            }
            case "Image": {
                return Optional.of(clazz.cast(this.image()));
            }
            case "MaxFaces": {
                return Optional.of(clazz.cast(this.maxFaces()));
            }
            case "FaceMatchThreshold": {
                return Optional.of(clazz.cast(this.faceMatchThreshold()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String collectionId;
        private Image image;
        private Integer maxFaces;
        private Float faceMatchThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesByImageRequest model) {
            this.collectionId(model.collectionId);
            this.image(model.image);
            this.maxFaces(model.maxFaces);
            this.faceMatchThreshold(model.faceMatchThreshold);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final Integer getMaxFaces() {
            return this.maxFaces;
        }

        @Override
        public final Builder maxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
            return this;
        }

        public final void setMaxFaces(Integer maxFaces) {
            this.maxFaces = maxFaces;
        }

        public final Float getFaceMatchThreshold() {
            return this.faceMatchThreshold;
        }

        @Override
        public final Builder faceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
            return this;
        }

        public final void setFaceMatchThreshold(Float faceMatchThreshold) {
            this.faceMatchThreshold = faceMatchThreshold;
        }

        public SearchFacesByImageRequest build() {
            return new SearchFacesByImageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchFacesByImageRequest> {
        public Builder collectionId(String var1);

        public Builder image(Image var1);

        public Builder maxFaces(Integer var1);

        public Builder faceMatchThreshold(Float var1);
    }
}

