/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.PoseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Pose
implements StructuredPojo,
ToCopyableBuilder<Builder, Pose> {
    private final Float roll;
    private final Float yaw;
    private final Float pitch;

    private Pose(BuilderImpl builder) {
        this.roll = builder.roll;
        this.yaw = builder.yaw;
        this.pitch = builder.pitch;
    }

    public Float roll() {
        return this.roll;
    }

    public Float yaw() {
        return this.yaw;
    }

    public Float pitch() {
        return this.pitch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roll() == null ? 0 : this.roll().hashCode());
        hashCode = 31 * hashCode + (this.yaw() == null ? 0 : this.yaw().hashCode());
        hashCode = 31 * hashCode + (this.pitch() == null ? 0 : this.pitch().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pose)) {
            return false;
        }
        Pose other = (Pose)obj;
        if (other.roll() == null ^ this.roll() == null) {
            return false;
        }
        if (other.roll() != null && !other.roll().equals(this.roll())) {
            return false;
        }
        if (other.yaw() == null ^ this.yaw() == null) {
            return false;
        }
        if (other.yaw() != null && !other.yaw().equals(this.yaw())) {
            return false;
        }
        if (other.pitch() == null ^ this.pitch() == null) {
            return false;
        }
        return other.pitch() == null || other.pitch().equals(this.pitch());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roll() != null) {
            sb.append("Roll: ").append(this.roll()).append(",");
        }
        if (this.yaw() != null) {
            sb.append("Yaw: ").append(this.yaw()).append(",");
        }
        if (this.pitch() != null) {
            sb.append("Pitch: ").append(this.pitch()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Roll": {
                return Optional.of(clazz.cast(this.roll()));
            }
            case "Yaw": {
                return Optional.of(clazz.cast(this.yaw()));
            }
            case "Pitch": {
                return Optional.of(clazz.cast(this.pitch()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PoseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float roll;
        private Float yaw;
        private Float pitch;

        private BuilderImpl() {
        }

        private BuilderImpl(Pose model) {
            this.roll(model.roll);
            this.yaw(model.yaw);
            this.pitch(model.pitch);
        }

        public final Float getRoll() {
            return this.roll;
        }

        @Override
        public final Builder roll(Float roll) {
            this.roll = roll;
            return this;
        }

        public final void setRoll(Float roll) {
            this.roll = roll;
        }

        public final Float getYaw() {
            return this.yaw;
        }

        @Override
        public final Builder yaw(Float yaw) {
            this.yaw = yaw;
            return this;
        }

        public final void setYaw(Float yaw) {
            this.yaw = yaw;
        }

        public final Float getPitch() {
            return this.pitch;
        }

        @Override
        public final Builder pitch(Float pitch) {
            this.pitch = pitch;
            return this;
        }

        public final void setPitch(Float pitch) {
            this.pitch = pitch;
        }

        public Pose build() {
            return new Pose(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Pose> {
        public Builder roll(Float var1);

        public Builder yaw(Float var1);

        public Builder pitch(Float var1);
    }
}

