/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rekognition.model.FaceIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteFacesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteFacesRequest> {
    private final String collectionId;
    private final List<String> faceIds;

    private DeleteFacesRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.faceIds = builder.faceIds;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public List<String> faceIds() {
        return this.faceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.collectionId() == null ? 0 : this.collectionId().hashCode());
        hashCode = 31 * hashCode + (this.faceIds() == null ? 0 : this.faceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesRequest)) {
            return false;
        }
        DeleteFacesRequest other = (DeleteFacesRequest)((Object)obj);
        if (other.collectionId() == null ^ this.collectionId() == null) {
            return false;
        }
        if (other.collectionId() != null && !other.collectionId().equals(this.collectionId())) {
            return false;
        }
        if (other.faceIds() == null ^ this.faceIds() == null) {
            return false;
        }
        return other.faceIds() == null || other.faceIds().equals(this.faceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.collectionId() != null) {
            sb.append("CollectionId: ").append(this.collectionId()).append(",");
        }
        if (this.faceIds() != null) {
            sb.append("FaceIds: ").append(this.faceIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.of(clazz.cast(this.collectionId()));
            }
            case "FaceIds": {
                return Optional.of(clazz.cast(this.faceIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String collectionId;
        private List<String> faceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesRequest model) {
            this.collectionId(model.collectionId);
            this.faceIds(model.faceIds);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Collection<String> getFaceIds() {
            return this.faceIds;
        }

        @Override
        public final Builder faceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceIds(String ... faceIds) {
            this.faceIds(Arrays.asList(faceIds));
            return this;
        }

        public final void setFaceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
        }

        public DeleteFacesRequest build() {
            return new DeleteFacesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteFacesRequest> {
        public Builder collectionId(String var1);

        public Builder faceIds(Collection<String> var1);

        public Builder faceIds(String ... var1);
    }
}

