/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.CompareFacesRequest;

@SdkInternalApi
public class CompareFacesRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> SOURCEIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceImage").build();
    private static final MarshallingInfo<StructuredPojo> TARGETIMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetImage").build();
    private static final MarshallingInfo<Float> SIMILARITYTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SimilarityThreshold").build();
    private static final CompareFacesRequestModelMarshaller instance = new CompareFacesRequestModelMarshaller();

    public static CompareFacesRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(CompareFacesRequest compareFacesRequest, ProtocolMarshaller protocolMarshaller) {
        if (compareFacesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)compareFacesRequest.sourceImage(), SOURCEIMAGE_BINDING);
            protocolMarshaller.marshall((Object)compareFacesRequest.targetImage(), TARGETIMAGE_BINDING);
            protocolMarshaller.marshall((Object)compareFacesRequest.similarityThreshold(), SIMILARITYTHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

