/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.FaceDetail;
import software.amazon.awssdk.services.rekognition.transform.FaceRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FaceRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, FaceRecord> {
    private final Face face;
    private final FaceDetail faceDetail;

    private FaceRecord(BuilderImpl builder) {
        this.face = builder.face;
        this.faceDetail = builder.faceDetail;
    }

    public Face face() {
        return this.face;
    }

    public FaceDetail faceDetail() {
        return this.faceDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.face() == null ? 0 : this.face().hashCode());
        hashCode = 31 * hashCode + (this.faceDetail() == null ? 0 : this.faceDetail().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceRecord)) {
            return false;
        }
        FaceRecord other = (FaceRecord)obj;
        if (other.face() == null ^ this.face() == null) {
            return false;
        }
        if (other.face() != null && !other.face().equals(this.face())) {
            return false;
        }
        if (other.faceDetail() == null ^ this.faceDetail() == null) {
            return false;
        }
        return other.faceDetail() == null || other.faceDetail().equals(this.faceDetail());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.face() != null) {
            sb.append("Face: ").append(this.face()).append(",");
        }
        if (this.faceDetail() != null) {
            sb.append("FaceDetail: ").append(this.faceDetail()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Face face;
        private FaceDetail faceDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceRecord model) {
            this.setFace(model.face);
            this.setFaceDetail(model.faceDetail);
        }

        public final Face getFace() {
            return this.face;
        }

        @Override
        public final Builder face(Face face) {
            this.face = face;
            return this;
        }

        public final void setFace(Face face) {
            this.face = face;
        }

        public final FaceDetail getFaceDetail() {
            return this.faceDetail;
        }

        @Override
        public final Builder faceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
            return this;
        }

        public final void setFaceDetail(FaceDetail faceDetail) {
            this.faceDetail = faceDetail;
        }

        public FaceRecord build() {
            return new FaceRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FaceRecord> {
        public Builder face(Face var1);

        public Builder faceDetail(FaceDetail var1);
    }
}

