/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.ImageQuality;
import software.amazon.awssdk.services.rekognition.model.Landmark;
import software.amazon.awssdk.services.rekognition.model.LandmarksCopier;
import software.amazon.awssdk.services.rekognition.model.Pose;
import software.amazon.awssdk.services.rekognition.transform.ComparedFaceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComparedFace
implements StructuredPojo,
ToCopyableBuilder<Builder, ComparedFace> {
    private final BoundingBox boundingBox;
    private final Float confidence;
    private final List<Landmark> landmarks;
    private final Pose pose;
    private final ImageQuality quality;

    private ComparedFace(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.confidence = builder.confidence;
        this.landmarks = builder.landmarks;
        this.pose = builder.pose;
        this.quality = builder.quality;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public Float confidence() {
        return this.confidence;
    }

    public List<Landmark> landmarks() {
        return this.landmarks;
    }

    public Pose pose() {
        return this.pose;
    }

    public ImageQuality quality() {
        return this.quality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.boundingBox() == null ? 0 : this.boundingBox().hashCode());
        hashCode = 31 * hashCode + (this.confidence() == null ? 0 : this.confidence().hashCode());
        hashCode = 31 * hashCode + (this.landmarks() == null ? 0 : this.landmarks().hashCode());
        hashCode = 31 * hashCode + (this.pose() == null ? 0 : this.pose().hashCode());
        hashCode = 31 * hashCode + (this.quality() == null ? 0 : this.quality().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComparedFace)) {
            return false;
        }
        ComparedFace other = (ComparedFace)obj;
        if (other.boundingBox() == null ^ this.boundingBox() == null) {
            return false;
        }
        if (other.boundingBox() != null && !other.boundingBox().equals(this.boundingBox())) {
            return false;
        }
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        if (other.confidence() != null && !other.confidence().equals(this.confidence())) {
            return false;
        }
        if (other.landmarks() == null ^ this.landmarks() == null) {
            return false;
        }
        if (other.landmarks() != null && !other.landmarks().equals(this.landmarks())) {
            return false;
        }
        if (other.pose() == null ^ this.pose() == null) {
            return false;
        }
        if (other.pose() != null && !other.pose().equals(this.pose())) {
            return false;
        }
        if (other.quality() == null ^ this.quality() == null) {
            return false;
        }
        return other.quality() == null || other.quality().equals(this.quality());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.boundingBox() != null) {
            sb.append("BoundingBox: ").append(this.boundingBox()).append(",");
        }
        if (this.confidence() != null) {
            sb.append("Confidence: ").append(this.confidence()).append(",");
        }
        if (this.landmarks() != null) {
            sb.append("Landmarks: ").append(this.landmarks()).append(",");
        }
        if (this.pose() != null) {
            sb.append("Pose: ").append(this.pose()).append(",");
        }
        if (this.quality() != null) {
            sb.append("Quality: ").append(this.quality()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComparedFaceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private Float confidence;
        private List<Landmark> landmarks;
        private Pose pose;
        private ImageQuality quality;

        private BuilderImpl() {
        }

        private BuilderImpl(ComparedFace model) {
            this.setBoundingBox(model.boundingBox);
            this.setConfidence(model.confidence);
            this.setLandmarks(model.landmarks);
            this.setPose(model.pose);
            this.setQuality(model.quality);
        }

        public final BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final Collection<Landmark> getLandmarks() {
            return this.landmarks;
        }

        @Override
        public final Builder landmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Landmark ... landmarks) {
            this.landmarks(Arrays.asList(landmarks));
            return this;
        }

        public final void setLandmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
        }

        @SafeVarargs
        public final void setLandmarks(Landmark ... landmarks) {
            this.landmarks(Arrays.asList(landmarks));
        }

        public final Pose getPose() {
            return this.pose;
        }

        @Override
        public final Builder pose(Pose pose) {
            this.pose = pose;
            return this;
        }

        public final void setPose(Pose pose) {
            this.pose = pose;
        }

        public final ImageQuality getQuality() {
            return this.quality;
        }

        @Override
        public final Builder quality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final void setQuality(ImageQuality quality) {
            this.quality = quality;
        }

        public ComparedFace build() {
            return new ComparedFace(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComparedFace> {
        public Builder boundingBox(BoundingBox var1);

        public Builder confidence(Float var1);

        public Builder landmarks(Collection<Landmark> var1);

        public Builder landmarks(Landmark ... var1);

        public Builder pose(Pose var1);

        public Builder quality(ImageQuality var1);
    }
}

