/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.VideoMetadata;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class VideoMetadataMarshaller {
    private static final MarshallingInfo<String> CODEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Codec").isBinary(false).build();
    private static final MarshallingInfo<Long> DURATIONMILLIS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationMillis").isBinary(false).build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").isBinary(false).build();
    private static final MarshallingInfo<Float> FRAMERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameRate").isBinary(false).build();
    private static final MarshallingInfo<Long> FRAMEHEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameHeight").isBinary(false).build();
    private static final MarshallingInfo<Long> FRAMEWIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameWidth").isBinary(false).build();
    private static final VideoMetadataMarshaller INSTANCE = new VideoMetadataMarshaller();

    private VideoMetadataMarshaller() {
    }

    public static VideoMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(VideoMetadata videoMetadata, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)videoMetadata, (String)"videoMetadata");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)videoMetadata.codec(), CODEC_BINDING);
            protocolMarshaller.marshall((Object)videoMetadata.durationMillis(), DURATIONMILLIS_BINDING);
            protocolMarshaller.marshall((Object)videoMetadata.format(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)videoMetadata.frameRate(), FRAMERATE_BINDING);
            protocolMarshaller.marshall((Object)videoMetadata.frameHeight(), FRAMEHEIGHT_BINDING);
            protocolMarshaller.marshall((Object)videoMetadata.frameWidth(), FRAMEWIDTH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

