/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.TextDetection;
import software.amazon.awssdk.services.rekognition.transform.GeometryUnmarshaller;

public class TextDetectionUnmarshaller
implements Unmarshaller<TextDetection, JsonUnmarshallerContext> {
    private static final TextDetectionUnmarshaller INSTANCE = new TextDetectionUnmarshaller();

    public TextDetection unmarshall(JsonUnmarshallerContext context) throws Exception {
        TextDetection.Builder textDetectionBuilder = TextDetection.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DetectedText", targetDepth)) {
                    context.nextToken();
                    textDetectionBuilder.detectedText((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    textDetectionBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    textDetectionBuilder.id((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ParentId", targetDepth)) {
                    context.nextToken();
                    textDetectionBuilder.parentId((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Confidence", targetDepth)) {
                    context.nextToken();
                    textDetectionBuilder.confidence((Float)context.getUnmarshaller(Float.class).unmarshall((Object)context));
                }
                if (context.testExpression("Geometry", targetDepth)) {
                    context.nextToken();
                    textDetectionBuilder.geometry(GeometryUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TextDetection)textDetectionBuilder.build();
    }

    public static TextDetectionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

