/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.StreamProcessorOutput;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamProcessorOutputMarshaller {
    private static final MarshallingInfo<StructuredPojo> KINESISDATASTREAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KinesisDataStream").isBinary(false).build();
    private static final StreamProcessorOutputMarshaller INSTANCE = new StreamProcessorOutputMarshaller();

    private StreamProcessorOutputMarshaller() {
    }

    public static StreamProcessorOutputMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StreamProcessorOutput streamProcessorOutput, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)streamProcessorOutput, (String)"streamProcessorOutput");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)streamProcessorOutput.kinesisDataStream(), KINESISDATASTREAM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

