/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.StartCelebrityRecognitionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartCelebrityRecognitionRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> VIDEO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Video").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOTIFICATIONCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationChannel").isBinary(false).build();
    private static final MarshallingInfo<String> JOBTAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobTag").isBinary(false).build();
    private static final StartCelebrityRecognitionRequestModelMarshaller INSTANCE = new StartCelebrityRecognitionRequestModelMarshaller();

    private StartCelebrityRecognitionRequestModelMarshaller() {
    }

    public static StartCelebrityRecognitionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StartCelebrityRecognitionRequest startCelebrityRecognitionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)startCelebrityRecognitionRequest), (String)"startCelebrityRecognitionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)startCelebrityRecognitionRequest.video(), VIDEO_BINDING);
            protocolMarshaller.marshall((Object)startCelebrityRecognitionRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)startCelebrityRecognitionRequest.notificationChannel(), NOTIFICATIONCHANNEL_BINDING);
            protocolMarshaller.marshall((Object)startCelebrityRecognitionRequest.jobTag(), JOBTAG_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

