/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.NotificationChannel;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class NotificationChannelMarshaller {
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SNSTopicArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final NotificationChannelMarshaller INSTANCE = new NotificationChannelMarshaller();

    private NotificationChannelMarshaller() {
    }

    public static NotificationChannelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(NotificationChannel notificationChannel, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)notificationChannel, (String)"notificationChannel");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)notificationChannel.snsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall((Object)notificationChannel.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

