/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rekognition.model.Geometry;
import software.amazon.awssdk.services.rekognition.transform.BoundingBoxUnmarshaller;
import software.amazon.awssdk.services.rekognition.transform.PointUnmarshaller;

public class GeometryUnmarshaller
implements Unmarshaller<Geometry, JsonUnmarshallerContext> {
    private static final GeometryUnmarshaller INSTANCE = new GeometryUnmarshaller();

    public Geometry unmarshall(JsonUnmarshallerContext context) throws Exception {
        Geometry.Builder geometryBuilder = Geometry.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BoundingBox", targetDepth)) {
                    context.nextToken();
                    geometryBuilder.boundingBox(BoundingBoxUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Polygon", targetDepth)) {
                    context.nextToken();
                    geometryBuilder.polygon(new ListUnmarshaller((Unmarshaller)PointUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Geometry)geometryBuilder.build();
    }

    public static GeometryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

