/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.FaceSearchSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FaceSearchSettingsMarshaller {
    private static final MarshallingInfo<String> COLLECTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CollectionId").isBinary(false).build();
    private static final MarshallingInfo<Float> FACEMATCHTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FaceMatchThreshold").isBinary(false).build();
    private static final FaceSearchSettingsMarshaller INSTANCE = new FaceSearchSettingsMarshaller();

    private FaceSearchSettingsMarshaller() {
    }

    public static FaceSearchSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(FaceSearchSettings faceSearchSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)faceSearchSettings, (String)"faceSearchSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)faceSearchSettings.collectionId(), COLLECTIONID_BINDING);
            protocolMarshaller.marshall((Object)faceSearchSettings.faceMatchThreshold(), FACEMATCHTHRESHOLD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

