/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.CompareFacesMatch;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CompareFacesMatchMarshaller {
    private static final MarshallingInfo<Float> SIMILARITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Similarity").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Face").isBinary(false).build();
    private static final CompareFacesMatchMarshaller INSTANCE = new CompareFacesMatchMarshaller();

    private CompareFacesMatchMarshaller() {
    }

    public static CompareFacesMatchMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CompareFacesMatch compareFacesMatch, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)compareFacesMatch, (String)"compareFacesMatch");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)compareFacesMatch.similarity(), SIMILARITY_BINDING);
            protocolMarshaller.marshall((Object)compareFacesMatch.face(), FACE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

