/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.AgeRange;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AgeRangeMarshaller {
    private static final MarshallingInfo<Integer> LOW_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Low").isBinary(false).build();
    private static final MarshallingInfo<Integer> HIGH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("High").isBinary(false).build();
    private static final AgeRangeMarshaller INSTANCE = new AgeRangeMarshaller();

    private AgeRangeMarshaller() {
    }

    public static AgeRangeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AgeRange ageRange, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ageRange, (String)"ageRange");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ageRange.low(), LOW_BINDING);
            protocolMarshaller.marshall((Object)ageRange.high(), HIGH_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

