/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.VideoMetadataMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoMetadata
implements StructuredPojo,
ToCopyableBuilder<Builder, VideoMetadata> {
    private final String codec;
    private final Long durationMillis;
    private final String format;
    private final Float frameRate;
    private final Long frameHeight;
    private final Long frameWidth;

    private VideoMetadata(BuilderImpl builder) {
        this.codec = builder.codec;
        this.durationMillis = builder.durationMillis;
        this.format = builder.format;
        this.frameRate = builder.frameRate;
        this.frameHeight = builder.frameHeight;
        this.frameWidth = builder.frameWidth;
    }

    public String codec() {
        return this.codec;
    }

    public Long durationMillis() {
        return this.durationMillis;
    }

    public String format() {
        return this.format;
    }

    public Float frameRate() {
        return this.frameRate;
    }

    public Long frameHeight() {
        return this.frameHeight;
    }

    public Long frameWidth() {
        return this.frameWidth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameWidth());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoMetadata)) {
            return false;
        }
        VideoMetadata other = (VideoMetadata)obj;
        return Objects.equals(this.codec(), other.codec()) && Objects.equals(this.durationMillis(), other.durationMillis()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.frameRate(), other.frameRate()) && Objects.equals(this.frameHeight(), other.frameHeight()) && Objects.equals(this.frameWidth(), other.frameWidth());
    }

    public String toString() {
        return ToString.builder((String)"VideoMetadata").add("Codec", (Object)this.codec()).add("DurationMillis", (Object)this.durationMillis()).add("Format", (Object)this.format()).add("FrameRate", (Object)this.frameRate()).add("FrameHeight", (Object)this.frameHeight()).add("FrameWidth", (Object)this.frameWidth()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "DurationMillis": {
                return Optional.ofNullable(clazz.cast(this.durationMillis()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "FrameRate": {
                return Optional.ofNullable(clazz.cast(this.frameRate()));
            }
            case "FrameHeight": {
                return Optional.ofNullable(clazz.cast(this.frameHeight()));
            }
            case "FrameWidth": {
                return Optional.ofNullable(clazz.cast(this.frameWidth()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String codec;
        private Long durationMillis;
        private String format;
        private Float frameRate;
        private Long frameHeight;
        private Long frameWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoMetadata model) {
            this.codec(model.codec);
            this.durationMillis(model.durationMillis);
            this.format(model.format);
            this.frameRate(model.frameRate);
            this.frameHeight(model.frameHeight);
            this.frameWidth(model.frameWidth);
        }

        public final String getCodec() {
            return this.codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final Long getDurationMillis() {
            return this.durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Float getFrameRate() {
            return this.frameRate;
        }

        @Override
        public final Builder frameRate(Float frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final void setFrameRate(Float frameRate) {
            this.frameRate = frameRate;
        }

        public final Long getFrameHeight() {
            return this.frameHeight;
        }

        @Override
        public final Builder frameHeight(Long frameHeight) {
            this.frameHeight = frameHeight;
            return this;
        }

        public final void setFrameHeight(Long frameHeight) {
            this.frameHeight = frameHeight;
        }

        public final Long getFrameWidth() {
            return this.frameWidth;
        }

        @Override
        public final Builder frameWidth(Long frameWidth) {
            this.frameWidth = frameWidth;
            return this;
        }

        public final void setFrameWidth(Long frameWidth) {
            this.frameWidth = frameWidth;
        }

        public VideoMetadata build() {
            return new VideoMetadata(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VideoMetadata> {
        public Builder codec(String var1);

        public Builder durationMillis(Long var1);

        public Builder format(String var1);

        public Builder frameRate(Float var1);

        public Builder frameHeight(Long var1);

        public Builder frameWidth(Long var1);
    }
}

