/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.PointMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Point
implements StructuredPojo,
ToCopyableBuilder<Builder, Point> {
    private final Float x;
    private final Float y;

    private Point(BuilderImpl builder) {
        this.x = builder.x;
        this.y = builder.y;
    }

    public Float x() {
        return this.x;
    }

    public Float y() {
        return this.y;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.x());
        hashCode = 31 * hashCode + Objects.hashCode(this.y());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Point)) {
            return false;
        }
        Point other = (Point)obj;
        return Objects.equals(this.x(), other.x()) && Objects.equals(this.y(), other.y());
    }

    public String toString() {
        return ToString.builder((String)"Point").add("X", (Object)this.x()).add("Y", (Object)this.y()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "X": {
                return Optional.ofNullable(clazz.cast(this.x()));
            }
            case "Y": {
                return Optional.ofNullable(clazz.cast(this.y()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float x;
        private Float y;

        private BuilderImpl() {
        }

        private BuilderImpl(Point model) {
            this.x(model.x);
            this.y(model.y);
        }

        public final Float getX() {
            return this.x;
        }

        @Override
        public final Builder x(Float x) {
            this.x = x;
            return this;
        }

        public final void setX(Float x) {
            this.x = x;
        }

        public final Float getY() {
            return this.y;
        }

        @Override
        public final Builder y(Float y) {
            this.y = y;
            return this;
        }

        public final void setY(Float y) {
            this.y = y;
        }

        public Point build() {
            return new Point(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Point> {
        public Builder x(Float var1);

        public Builder y(Float var1);
    }
}

