/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ModerationLabelMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModerationLabel
implements StructuredPojo,
ToCopyableBuilder<Builder, ModerationLabel> {
    private final Float confidence;
    private final String name;
    private final String parentName;

    private ModerationLabel(BuilderImpl builder) {
        this.confidence = builder.confidence;
        this.name = builder.name;
        this.parentName = builder.parentName;
    }

    public Float confidence() {
        return this.confidence;
    }

    public String name() {
        return this.name;
    }

    public String parentName() {
        return this.parentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModerationLabel)) {
            return false;
        }
        ModerationLabel other = (ModerationLabel)obj;
        return Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.parentName(), other.parentName());
    }

    public String toString() {
        return ToString.builder((String)"ModerationLabel").add("Confidence", (Object)this.confidence()).add("Name", (Object)this.name()).add("ParentName", (Object)this.parentName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ParentName": {
                return Optional.ofNullable(clazz.cast(this.parentName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ModerationLabelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Float confidence;
        private String name;
        private String parentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModerationLabel model) {
            this.confidence(model.confidence);
            this.name(model.name);
            this.parentName(model.parentName);
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getParentName() {
            return this.parentName;
        }

        @Override
        public final Builder parentName(String parentName) {
            this.parentName = parentName;
            return this;
        }

        public final void setParentName(String parentName) {
            this.parentName = parentName;
        }

        public ModerationLabel build() {
            return new ModerationLabel(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModerationLabel> {
        public Builder confidence(Float var1);

        public Builder name(String var1);

        public Builder parentName(String var1);
    }
}

