/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.FaceListCopier;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFacesResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, ListFacesResponse> {
    private final List<Face> faces;
    private final String nextToken;
    private final String faceModelVersion;

    private ListFacesResponse(BuilderImpl builder) {
        super(builder);
        this.faces = builder.faces;
        this.nextToken = builder.nextToken;
        this.faceModelVersion = builder.faceModelVersion;
    }

    public List<Face> faces() {
        return this.faces;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String faceModelVersion() {
        return this.faceModelVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.faces());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceModelVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesResponse)) {
            return false;
        }
        ListFacesResponse other = (ListFacesResponse)((Object)obj);
        return Objects.equals(this.faces(), other.faces()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.faceModelVersion(), other.faceModelVersion());
    }

    public String toString() {
        return ToString.builder((String)"ListFacesResponse").add("Faces", this.faces()).add("NextToken", (Object)this.nextToken()).add("FaceModelVersion", (Object)this.faceModelVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Faces": {
                return Optional.ofNullable(clazz.cast(this.faces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FaceModelVersion": {
                return Optional.ofNullable(clazz.cast(this.faceModelVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<Face> faces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String faceModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacesResponse model) {
            super(model);
            this.faces(model.faces);
            this.nextToken(model.nextToken);
            this.faceModelVersion(model.faceModelVersion);
        }

        public final Collection<Face.Builder> getFaces() {
            return this.faces != null ? (Collection)this.faces.stream().map(Face::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder faces(Collection<Face> faces) {
            this.faces = FaceListCopier.copy(faces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Face ... faces) {
            this.faces(Arrays.asList(faces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Consumer<Face.Builder> ... faces) {
            this.faces(Stream.of(faces).map(c -> (Face)((Face.Builder)Face.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFaces(Collection<Face.BuilderImpl> faces) {
            this.faces = FaceListCopier.copyFromBuilder(faces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getFaceModelVersion() {
            return this.faceModelVersion;
        }

        @Override
        public final Builder faceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
            return this;
        }

        public final void setFaceModelVersion(String faceModelVersion) {
            this.faceModelVersion = faceModelVersion;
        }

        @Override
        public ListFacesResponse build() {
            return new ListFacesResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, ListFacesResponse> {
        public Builder faces(Collection<Face> var1);

        public Builder faces(Face ... var1);

        public Builder faces(Consumer<Face.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder faceModelVersion(String var1);
    }
}

