/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Attribute;
import software.amazon.awssdk.services.rekognition.model.AttributesCopier;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexFacesRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, IndexFacesRequest> {
    private final String collectionId;
    private final Image image;
    private final String externalImageId;
    private final List<String> detectionAttributes;

    private IndexFacesRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.externalImageId = builder.externalImageId;
        this.detectionAttributes = builder.detectionAttributes;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public Image image() {
        return this.image;
    }

    public String externalImageId() {
        return this.externalImageId;
    }

    public List<Attribute> detectionAttributes() {
        return TypeConverter.convert(this.detectionAttributes, Attribute::fromValue);
    }

    public List<String> detectionAttributesAsStrings() {
        return this.detectionAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectionAttributesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesRequest)) {
            return false;
        }
        IndexFacesRequest other = (IndexFacesRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.externalImageId(), other.externalImageId()) && Objects.equals(this.detectionAttributesAsStrings(), other.detectionAttributesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"IndexFacesRequest").add("CollectionId", (Object)this.collectionId()).add("Image", (Object)this.image()).add("ExternalImageId", (Object)this.externalImageId()).add("DetectionAttributes", this.detectionAttributesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "ExternalImageId": {
                return Optional.ofNullable(clazz.cast(this.externalImageId()));
            }
            case "DetectionAttributes": {
                return Optional.ofNullable(clazz.cast(this.detectionAttributesAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private Image image;
        private String externalImageId;
        private List<String> detectionAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesRequest model) {
            super(model);
            this.collectionId(model.collectionId);
            this.image(model.image);
            this.externalImageId(model.externalImageId);
            this.detectionAttributesWithStrings(model.detectionAttributes);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Image.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final String getExternalImageId() {
            return this.externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Collection<String> getDetectionAttributes() {
            return this.detectionAttributes;
        }

        @Override
        public final Builder detectionAttributesWithStrings(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributesWithStrings(String ... detectionAttributes) {
            this.detectionAttributesWithStrings(Arrays.asList(detectionAttributes));
            return this;
        }

        @Override
        public final Builder detectionAttributes(Collection<Attribute> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copyEnumToString(detectionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributes(Attribute ... detectionAttributes) {
            this.detectionAttributes(Arrays.asList(detectionAttributes));
            return this;
        }

        public final void setDetectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IndexFacesRequest build() {
            return new IndexFacesRequest(this);
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    CopyableBuilder<Builder, IndexFacesRequest> {
        public Builder collectionId(String var1);

        public Builder image(Image var1);

        default public Builder image(Consumer<Image.Builder> image) {
            return this.image((Image)((Image.Builder)Image.builder().applyMutation(image)).build());
        }

        public Builder externalImageId(String var1);

        public Builder detectionAttributesWithStrings(Collection<String> var1);

        public Builder detectionAttributesWithStrings(String ... var1);

        public Builder detectionAttributes(Collection<Attribute> var1);

        public Builder detectionAttributes(Attribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

