/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.Point;
import software.amazon.awssdk.services.rekognition.model.PolygonCopier;
import software.amazon.awssdk.services.rekognition.transform.GeometryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Geometry
implements StructuredPojo,
ToCopyableBuilder<Builder, Geometry> {
    private final BoundingBox boundingBox;
    private final List<Point> polygon;

    private Geometry(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.polygon = builder.polygon;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public List<Point> polygon() {
        return this.polygon;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.boundingBox());
        hashCode = 31 * hashCode + Objects.hashCode(this.polygon());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry other = (Geometry)obj;
        return Objects.equals(this.boundingBox(), other.boundingBox()) && Objects.equals(this.polygon(), other.polygon());
    }

    public String toString() {
        return ToString.builder((String)"Geometry").add("BoundingBox", (Object)this.boundingBox()).add("Polygon", this.polygon()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BoundingBox": {
                return Optional.ofNullable(clazz.cast(this.boundingBox()));
            }
            case "Polygon": {
                return Optional.ofNullable(clazz.cast(this.polygon()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeometryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private List<Point> polygon = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Geometry model) {
            this.boundingBox(model.boundingBox);
            this.polygon(model.polygon);
        }

        public final BoundingBox.Builder getBoundingBox() {
            return this.boundingBox != null ? this.boundingBox.toBuilder() : null;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox.BuilderImpl boundingBox) {
            this.boundingBox = boundingBox != null ? boundingBox.build() : null;
        }

        public final Collection<Point.Builder> getPolygon() {
            return this.polygon != null ? (Collection)this.polygon.stream().map(Point::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder polygon(Collection<Point> polygon) {
            this.polygon = PolygonCopier.copy(polygon);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Point ... polygon) {
            this.polygon(Arrays.asList(polygon));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder polygon(Consumer<Point.Builder> ... polygon) {
            this.polygon(Stream.of(polygon).map(c -> (Point)((Point.Builder)Point.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolygon(Collection<Point.BuilderImpl> polygon) {
            this.polygon = PolygonCopier.copyFromBuilder(polygon);
        }

        public Geometry build() {
            return new Geometry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Geometry> {
        public Builder boundingBox(BoundingBox var1);

        default public Builder boundingBox(Consumer<BoundingBox.Builder> boundingBox) {
            return this.boundingBox((BoundingBox)((BoundingBox.Builder)BoundingBox.builder().applyMutation(boundingBox)).build());
        }

        public Builder polygon(Collection<Point> var1);

        public Builder polygon(Point ... var1);

        public Builder polygon(Consumer<Point.Builder> ... var1);
    }
}

