/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.services.rekognition.model.TextDetection;
import software.amazon.awssdk.services.rekognition.model.TextDetectionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectTextResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectTextResponse> {
    private final List<TextDetection> textDetections;

    private DetectTextResponse(BuilderImpl builder) {
        super(builder);
        this.textDetections = builder.textDetections;
    }

    public List<TextDetection> textDetections() {
        return this.textDetections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textDetections());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectTextResponse)) {
            return false;
        }
        DetectTextResponse other = (DetectTextResponse)((Object)obj);
        return Objects.equals(this.textDetections(), other.textDetections());
    }

    public String toString() {
        return ToString.builder((String)"DetectTextResponse").add("TextDetections", this.textDetections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextDetections": {
                return Optional.ofNullable(clazz.cast(this.textDetections()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<TextDetection> textDetections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectTextResponse model) {
            super(model);
            this.textDetections(model.textDetections);
        }

        public final Collection<TextDetection.Builder> getTextDetections() {
            return this.textDetections != null ? (Collection)this.textDetections.stream().map(TextDetection::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder textDetections(Collection<TextDetection> textDetections) {
            this.textDetections = TextDetectionListCopier.copy(textDetections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(TextDetection ... textDetections) {
            this.textDetections(Arrays.asList(textDetections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder textDetections(Consumer<TextDetection.Builder> ... textDetections) {
            this.textDetections(Stream.of(textDetections).map(c -> (TextDetection)((TextDetection.Builder)TextDetection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTextDetections(Collection<TextDetection.BuilderImpl> textDetections) {
            this.textDetections = TextDetectionListCopier.copyFromBuilder(textDetections);
        }

        @Override
        public DetectTextResponse build() {
            return new DetectTextResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, DetectTextResponse> {
        public Builder textDetections(Collection<TextDetection> var1);

        public Builder textDetections(TextDetection ... var1);

        public Builder textDetections(Consumer<TextDetection.Builder> ... var1);
    }
}

