/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rekognition.model.Label;
import software.amazon.awssdk.services.rekognition.model.LabelsCopier;
import software.amazon.awssdk.services.rekognition.model.OrientationCorrection;
import software.amazon.awssdk.services.rekognition.model.RekognitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectLabelsResponse
extends RekognitionResponse
implements ToCopyableBuilder<Builder, DetectLabelsResponse> {
    private final List<Label> labels;
    private final String orientationCorrection;

    private DetectLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.labels = builder.labels;
        this.orientationCorrection = builder.orientationCorrection;
    }

    public List<Label> labels() {
        return this.labels;
    }

    public OrientationCorrection orientationCorrection() {
        return OrientationCorrection.fromValue(this.orientationCorrection);
    }

    public String orientationCorrectionAsString() {
        return this.orientationCorrection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationCorrectionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectLabelsResponse)) {
            return false;
        }
        DetectLabelsResponse other = (DetectLabelsResponse)((Object)obj);
        return Objects.equals(this.labels(), other.labels()) && Objects.equals(this.orientationCorrectionAsString(), other.orientationCorrectionAsString());
    }

    public String toString() {
        return ToString.builder((String)"DetectLabelsResponse").add("Labels", this.labels()).add("OrientationCorrection", (Object)this.orientationCorrectionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Labels": {
                return Optional.ofNullable(clazz.cast(this.labels()));
            }
            case "OrientationCorrection": {
                return Optional.ofNullable(clazz.cast(this.orientationCorrectionAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RekognitionResponse.BuilderImpl
    implements Builder {
        private List<Label> labels = DefaultSdkAutoConstructList.getInstance();
        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectLabelsResponse model) {
            super(model);
            this.labels(model.labels);
            this.orientationCorrection(model.orientationCorrection);
        }

        public final Collection<Label.Builder> getLabels() {
            return this.labels != null ? (Collection)this.labels.stream().map(Label::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labels(Collection<Label> labels) {
            this.labels = LabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Label ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(Consumer<Label.Builder> ... labels) {
            this.labels(Stream.of(labels).map(c -> (Label)((Label.Builder)Label.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabels(Collection<Label.BuilderImpl> labels) {
            this.labels = LabelsCopier.copyFromBuilder(labels);
        }

        public final String getOrientationCorrection() {
            return this.orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        @Override
        public DetectLabelsResponse build() {
            return new DetectLabelsResponse(this);
        }
    }

    public static interface Builder
    extends RekognitionResponse.Builder,
    CopyableBuilder<Builder, DetectLabelsResponse> {
        public Builder labels(Collection<Label> var1);

        public Builder labels(Label ... var1);

        public Builder labels(Consumer<Label.Builder> ... var1);

        public Builder orientationCorrection(String var1);

        public Builder orientationCorrection(OrientationCorrection var1);
    }
}

