/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.AgeRangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgeRange
implements StructuredPojo,
ToCopyableBuilder<Builder, AgeRange> {
    private final Integer low;
    private final Integer high;

    private AgeRange(BuilderImpl builder) {
        this.low = builder.low;
        this.high = builder.high;
    }

    public Integer low() {
        return this.low;
    }

    public Integer high() {
        return this.high;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.low());
        hashCode = 31 * hashCode + Objects.hashCode(this.high());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgeRange)) {
            return false;
        }
        AgeRange other = (AgeRange)obj;
        return Objects.equals(this.low(), other.low()) && Objects.equals(this.high(), other.high());
    }

    public String toString() {
        return ToString.builder((String)"AgeRange").add("Low", (Object)this.low()).add("High", (Object)this.high()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Low": {
                return Optional.ofNullable(clazz.cast(this.low()));
            }
            case "High": {
                return Optional.ofNullable(clazz.cast(this.high()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AgeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer low;
        private Integer high;

        private BuilderImpl() {
        }

        private BuilderImpl(AgeRange model) {
            this.low(model.low);
            this.high(model.high);
        }

        public final Integer getLow() {
            return this.low;
        }

        @Override
        public final Builder low(Integer low) {
            this.low = low;
            return this;
        }

        public final void setLow(Integer low) {
            this.low = low;
        }

        public final Integer getHigh() {
            return this.high;
        }

        @Override
        public final Builder high(Integer high) {
            this.high = high;
            return this;
        }

        public final void setHigh(Integer high) {
            this.high = high;
        }

        public AgeRange build() {
            return new AgeRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AgeRange> {
        public Builder low(Integer var1);

        public Builder high(Integer var1);
    }
}

