/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;

@SdkInternalApi
public class BoundingBoxMarshaller {
    private static final MarshallingInfo<Float> WIDTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Width").build();
    private static final MarshallingInfo<Float> HEIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Height").build();
    private static final MarshallingInfo<Float> LEFT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Left").build();
    private static final MarshallingInfo<Float> TOP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Top").build();
    private static final BoundingBoxMarshaller instance = new BoundingBoxMarshaller();

    public static BoundingBoxMarshaller getInstance() {
        return instance;
    }

    public void marshall(BoundingBox boundingBox, ProtocolMarshaller protocolMarshaller) {
        if (boundingBox == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)boundingBox.width(), WIDTH_BINDING);
            protocolMarshaller.marshall((Object)boundingBox.height(), HEIGHT_BINDING);
            protocolMarshaller.marshall((Object)boundingBox.left(), LEFT_BINDING);
            protocolMarshaller.marshall((Object)boundingBox.top(), TOP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

