/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.FaceMatch;
import software.amazon.awssdk.services.rekognition.model.FaceMatchListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchFacesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, SearchFacesResponse> {
    private final String searchedFaceId;
    private final List<FaceMatch> faceMatches;

    private SearchFacesResponse(BuilderImpl builder) {
        this.searchedFaceId = builder.searchedFaceId;
        this.faceMatches = builder.faceMatches;
    }

    public String searchedFaceId() {
        return this.searchedFaceId;
    }

    public List<FaceMatch> faceMatches() {
        return this.faceMatches;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.searchedFaceId() == null ? 0 : this.searchedFaceId().hashCode());
        hashCode = 31 * hashCode + (this.faceMatches() == null ? 0 : this.faceMatches().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesResponse)) {
            return false;
        }
        SearchFacesResponse other = (SearchFacesResponse)((Object)obj);
        if (other.searchedFaceId() == null ^ this.searchedFaceId() == null) {
            return false;
        }
        if (other.searchedFaceId() != null && !other.searchedFaceId().equals(this.searchedFaceId())) {
            return false;
        }
        if (other.faceMatches() == null ^ this.faceMatches() == null) {
            return false;
        }
        return other.faceMatches() == null || other.faceMatches().equals(this.faceMatches());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.searchedFaceId() != null) {
            sb.append("SearchedFaceId: ").append(this.searchedFaceId()).append(",");
        }
        if (this.faceMatches() != null) {
            sb.append("FaceMatches: ").append(this.faceMatches()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String searchedFaceId;
        private List<FaceMatch> faceMatches;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesResponse model) {
            this.setSearchedFaceId(model.searchedFaceId);
            this.setFaceMatches(model.faceMatches);
        }

        public final String getSearchedFaceId() {
            return this.searchedFaceId;
        }

        @Override
        public final Builder searchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
            return this;
        }

        public final void setSearchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
        }

        public final Collection<FaceMatch> getFaceMatches() {
            return this.faceMatches;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch ... faceMatches) {
            if (this.faceMatches == null) {
                this.faceMatches = new ArrayList<FaceMatch>(faceMatches.length);
            }
            for (FaceMatch e : faceMatches) {
                this.faceMatches.add(e);
            }
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
        }

        @SafeVarargs
        public final void setFaceMatches(FaceMatch ... faceMatches) {
            if (this.faceMatches == null) {
                this.faceMatches = new ArrayList<FaceMatch>(faceMatches.length);
            }
            for (FaceMatch e : faceMatches) {
                this.faceMatches.add(e);
            }
        }

        public SearchFacesResponse build() {
            return new SearchFacesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchFacesResponse> {
        public Builder searchedFaceId(String var1);

        public Builder faceMatches(Collection<FaceMatch> var1);

        public Builder faceMatches(FaceMatch ... var1);
    }
}

