/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rekognition.model.UrlsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCelebrityInfoResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetCelebrityInfoResponse> {
    private final List<String> urls;
    private final String name;

    private GetCelebrityInfoResponse(BuilderImpl builder) {
        this.urls = builder.urls;
        this.name = builder.name;
    }

    public List<String> urls() {
        return this.urls;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.urls() == null ? 0 : this.urls().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCelebrityInfoResponse)) {
            return false;
        }
        GetCelebrityInfoResponse other = (GetCelebrityInfoResponse)((Object)obj);
        if (other.urls() == null ^ this.urls() == null) {
            return false;
        }
        if (other.urls() != null && !other.urls().equals(this.urls())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        return other.name() == null || other.name().equals(this.name());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.urls() != null) {
            sb.append("Urls: ").append(this.urls()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> urls;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCelebrityInfoResponse model) {
            this.setUrls(model.urls);
            this.setName(model.name);
        }

        public final Collection<String> getUrls() {
            return this.urls;
        }

        @Override
        public final Builder urls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urls(String ... urls) {
            if (this.urls == null) {
                this.urls = new ArrayList<String>(urls.length);
            }
            for (String e : urls) {
                this.urls.add(e);
            }
            return this;
        }

        public final void setUrls(Collection<String> urls) {
            this.urls = UrlsCopier.copy(urls);
        }

        @SafeVarargs
        public final void setUrls(String ... urls) {
            if (this.urls == null) {
                this.urls = new ArrayList<String>(urls.length);
            }
            for (String e : urls) {
                this.urls.add(e);
            }
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public GetCelebrityInfoResponse build() {
            return new GetCelebrityInfoResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetCelebrityInfoResponse> {
        public Builder urls(Collection<String> var1);

        public Builder urls(String ... var1);

        public Builder name(String var1);
    }
}

