/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.model.AgeRange;
import software.amazon.awssdk.services.rekognition.model.Beard;
import software.amazon.awssdk.services.rekognition.model.BoundingBox;
import software.amazon.awssdk.services.rekognition.model.Emotion;
import software.amazon.awssdk.services.rekognition.model.EmotionsCopier;
import software.amazon.awssdk.services.rekognition.model.EyeOpen;
import software.amazon.awssdk.services.rekognition.model.Eyeglasses;
import software.amazon.awssdk.services.rekognition.model.Gender;
import software.amazon.awssdk.services.rekognition.model.ImageQuality;
import software.amazon.awssdk.services.rekognition.model.Landmark;
import software.amazon.awssdk.services.rekognition.model.LandmarksCopier;
import software.amazon.awssdk.services.rekognition.model.MouthOpen;
import software.amazon.awssdk.services.rekognition.model.Mustache;
import software.amazon.awssdk.services.rekognition.model.Pose;
import software.amazon.awssdk.services.rekognition.model.Smile;
import software.amazon.awssdk.services.rekognition.model.Sunglasses;
import software.amazon.awssdk.services.rekognition.transform.FaceDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FaceDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, FaceDetail> {
    private final BoundingBox boundingBox;
    private final AgeRange ageRange;
    private final Smile smile;
    private final Eyeglasses eyeglasses;
    private final Sunglasses sunglasses;
    private final Gender gender;
    private final Beard beard;
    private final Mustache mustache;
    private final EyeOpen eyesOpen;
    private final MouthOpen mouthOpen;
    private final List<Emotion> emotions;
    private final List<Landmark> landmarks;
    private final Pose pose;
    private final ImageQuality quality;
    private final Float confidence;

    private FaceDetail(BuilderImpl builder) {
        this.boundingBox = builder.boundingBox;
        this.ageRange = builder.ageRange;
        this.smile = builder.smile;
        this.eyeglasses = builder.eyeglasses;
        this.sunglasses = builder.sunglasses;
        this.gender = builder.gender;
        this.beard = builder.beard;
        this.mustache = builder.mustache;
        this.eyesOpen = builder.eyesOpen;
        this.mouthOpen = builder.mouthOpen;
        this.emotions = builder.emotions;
        this.landmarks = builder.landmarks;
        this.pose = builder.pose;
        this.quality = builder.quality;
        this.confidence = builder.confidence;
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public AgeRange ageRange() {
        return this.ageRange;
    }

    public Smile smile() {
        return this.smile;
    }

    public Eyeglasses eyeglasses() {
        return this.eyeglasses;
    }

    public Sunglasses sunglasses() {
        return this.sunglasses;
    }

    public Gender gender() {
        return this.gender;
    }

    public Beard beard() {
        return this.beard;
    }

    public Mustache mustache() {
        return this.mustache;
    }

    public EyeOpen eyesOpen() {
        return this.eyesOpen;
    }

    public MouthOpen mouthOpen() {
        return this.mouthOpen;
    }

    public List<Emotion> emotions() {
        return this.emotions;
    }

    public List<Landmark> landmarks() {
        return this.landmarks;
    }

    public Pose pose() {
        return this.pose;
    }

    public ImageQuality quality() {
        return this.quality;
    }

    public Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.boundingBox() == null ? 0 : this.boundingBox().hashCode());
        hashCode = 31 * hashCode + (this.ageRange() == null ? 0 : this.ageRange().hashCode());
        hashCode = 31 * hashCode + (this.smile() == null ? 0 : this.smile().hashCode());
        hashCode = 31 * hashCode + (this.eyeglasses() == null ? 0 : this.eyeglasses().hashCode());
        hashCode = 31 * hashCode + (this.sunglasses() == null ? 0 : this.sunglasses().hashCode());
        hashCode = 31 * hashCode + (this.gender() == null ? 0 : this.gender().hashCode());
        hashCode = 31 * hashCode + (this.beard() == null ? 0 : this.beard().hashCode());
        hashCode = 31 * hashCode + (this.mustache() == null ? 0 : this.mustache().hashCode());
        hashCode = 31 * hashCode + (this.eyesOpen() == null ? 0 : this.eyesOpen().hashCode());
        hashCode = 31 * hashCode + (this.mouthOpen() == null ? 0 : this.mouthOpen().hashCode());
        hashCode = 31 * hashCode + (this.emotions() == null ? 0 : this.emotions().hashCode());
        hashCode = 31 * hashCode + (this.landmarks() == null ? 0 : this.landmarks().hashCode());
        hashCode = 31 * hashCode + (this.pose() == null ? 0 : this.pose().hashCode());
        hashCode = 31 * hashCode + (this.quality() == null ? 0 : this.quality().hashCode());
        hashCode = 31 * hashCode + (this.confidence() == null ? 0 : this.confidence().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FaceDetail)) {
            return false;
        }
        FaceDetail other = (FaceDetail)obj;
        if (other.boundingBox() == null ^ this.boundingBox() == null) {
            return false;
        }
        if (other.boundingBox() != null && !other.boundingBox().equals(this.boundingBox())) {
            return false;
        }
        if (other.ageRange() == null ^ this.ageRange() == null) {
            return false;
        }
        if (other.ageRange() != null && !other.ageRange().equals(this.ageRange())) {
            return false;
        }
        if (other.smile() == null ^ this.smile() == null) {
            return false;
        }
        if (other.smile() != null && !other.smile().equals(this.smile())) {
            return false;
        }
        if (other.eyeglasses() == null ^ this.eyeglasses() == null) {
            return false;
        }
        if (other.eyeglasses() != null && !other.eyeglasses().equals(this.eyeglasses())) {
            return false;
        }
        if (other.sunglasses() == null ^ this.sunglasses() == null) {
            return false;
        }
        if (other.sunglasses() != null && !other.sunglasses().equals(this.sunglasses())) {
            return false;
        }
        if (other.gender() == null ^ this.gender() == null) {
            return false;
        }
        if (other.gender() != null && !other.gender().equals(this.gender())) {
            return false;
        }
        if (other.beard() == null ^ this.beard() == null) {
            return false;
        }
        if (other.beard() != null && !other.beard().equals(this.beard())) {
            return false;
        }
        if (other.mustache() == null ^ this.mustache() == null) {
            return false;
        }
        if (other.mustache() != null && !other.mustache().equals(this.mustache())) {
            return false;
        }
        if (other.eyesOpen() == null ^ this.eyesOpen() == null) {
            return false;
        }
        if (other.eyesOpen() != null && !other.eyesOpen().equals(this.eyesOpen())) {
            return false;
        }
        if (other.mouthOpen() == null ^ this.mouthOpen() == null) {
            return false;
        }
        if (other.mouthOpen() != null && !other.mouthOpen().equals(this.mouthOpen())) {
            return false;
        }
        if (other.emotions() == null ^ this.emotions() == null) {
            return false;
        }
        if (other.emotions() != null && !other.emotions().equals(this.emotions())) {
            return false;
        }
        if (other.landmarks() == null ^ this.landmarks() == null) {
            return false;
        }
        if (other.landmarks() != null && !other.landmarks().equals(this.landmarks())) {
            return false;
        }
        if (other.pose() == null ^ this.pose() == null) {
            return false;
        }
        if (other.pose() != null && !other.pose().equals(this.pose())) {
            return false;
        }
        if (other.quality() == null ^ this.quality() == null) {
            return false;
        }
        if (other.quality() != null && !other.quality().equals(this.quality())) {
            return false;
        }
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        return other.confidence() == null || other.confidence().equals(this.confidence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.boundingBox() != null) {
            sb.append("BoundingBox: ").append(this.boundingBox()).append(",");
        }
        if (this.ageRange() != null) {
            sb.append("AgeRange: ").append(this.ageRange()).append(",");
        }
        if (this.smile() != null) {
            sb.append("Smile: ").append(this.smile()).append(",");
        }
        if (this.eyeglasses() != null) {
            sb.append("Eyeglasses: ").append(this.eyeglasses()).append(",");
        }
        if (this.sunglasses() != null) {
            sb.append("Sunglasses: ").append(this.sunglasses()).append(",");
        }
        if (this.gender() != null) {
            sb.append("Gender: ").append(this.gender()).append(",");
        }
        if (this.beard() != null) {
            sb.append("Beard: ").append(this.beard()).append(",");
        }
        if (this.mustache() != null) {
            sb.append("Mustache: ").append(this.mustache()).append(",");
        }
        if (this.eyesOpen() != null) {
            sb.append("EyesOpen: ").append(this.eyesOpen()).append(",");
        }
        if (this.mouthOpen() != null) {
            sb.append("MouthOpen: ").append(this.mouthOpen()).append(",");
        }
        if (this.emotions() != null) {
            sb.append("Emotions: ").append(this.emotions()).append(",");
        }
        if (this.landmarks() != null) {
            sb.append("Landmarks: ").append(this.landmarks()).append(",");
        }
        if (this.pose() != null) {
            sb.append("Pose: ").append(this.pose()).append(",");
        }
        if (this.quality() != null) {
            sb.append("Quality: ").append(this.quality()).append(",");
        }
        if (this.confidence() != null) {
            sb.append("Confidence: ").append(this.confidence()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FaceDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private BoundingBox boundingBox;
        private AgeRange ageRange;
        private Smile smile;
        private Eyeglasses eyeglasses;
        private Sunglasses sunglasses;
        private Gender gender;
        private Beard beard;
        private Mustache mustache;
        private EyeOpen eyesOpen;
        private MouthOpen mouthOpen;
        private List<Emotion> emotions;
        private List<Landmark> landmarks;
        private Pose pose;
        private ImageQuality quality;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(FaceDetail model) {
            this.setBoundingBox(model.boundingBox);
            this.setAgeRange(model.ageRange);
            this.setSmile(model.smile);
            this.setEyeglasses(model.eyeglasses);
            this.setSunglasses(model.sunglasses);
            this.setGender(model.gender);
            this.setBeard(model.beard);
            this.setMustache(model.mustache);
            this.setEyesOpen(model.eyesOpen);
            this.setMouthOpen(model.mouthOpen);
            this.setEmotions(model.emotions);
            this.setLandmarks(model.landmarks);
            this.setPose(model.pose);
            this.setQuality(model.quality);
            this.setConfidence(model.confidence);
        }

        public final BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public final Builder boundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
            return this;
        }

        public final void setBoundingBox(BoundingBox boundingBox) {
            this.boundingBox = boundingBox;
        }

        public final AgeRange getAgeRange() {
            return this.ageRange;
        }

        @Override
        public final Builder ageRange(AgeRange ageRange) {
            this.ageRange = ageRange;
            return this;
        }

        public final void setAgeRange(AgeRange ageRange) {
            this.ageRange = ageRange;
        }

        public final Smile getSmile() {
            return this.smile;
        }

        @Override
        public final Builder smile(Smile smile) {
            this.smile = smile;
            return this;
        }

        public final void setSmile(Smile smile) {
            this.smile = smile;
        }

        public final Eyeglasses getEyeglasses() {
            return this.eyeglasses;
        }

        @Override
        public final Builder eyeglasses(Eyeglasses eyeglasses) {
            this.eyeglasses = eyeglasses;
            return this;
        }

        public final void setEyeglasses(Eyeglasses eyeglasses) {
            this.eyeglasses = eyeglasses;
        }

        public final Sunglasses getSunglasses() {
            return this.sunglasses;
        }

        @Override
        public final Builder sunglasses(Sunglasses sunglasses) {
            this.sunglasses = sunglasses;
            return this;
        }

        public final void setSunglasses(Sunglasses sunglasses) {
            this.sunglasses = sunglasses;
        }

        public final Gender getGender() {
            return this.gender;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender = gender;
            return this;
        }

        public final void setGender(Gender gender) {
            this.gender = gender;
        }

        public final Beard getBeard() {
            return this.beard;
        }

        @Override
        public final Builder beard(Beard beard) {
            this.beard = beard;
            return this;
        }

        public final void setBeard(Beard beard) {
            this.beard = beard;
        }

        public final Mustache getMustache() {
            return this.mustache;
        }

        @Override
        public final Builder mustache(Mustache mustache) {
            this.mustache = mustache;
            return this;
        }

        public final void setMustache(Mustache mustache) {
            this.mustache = mustache;
        }

        public final EyeOpen getEyesOpen() {
            return this.eyesOpen;
        }

        @Override
        public final Builder eyesOpen(EyeOpen eyesOpen) {
            this.eyesOpen = eyesOpen;
            return this;
        }

        public final void setEyesOpen(EyeOpen eyesOpen) {
            this.eyesOpen = eyesOpen;
        }

        public final MouthOpen getMouthOpen() {
            return this.mouthOpen;
        }

        @Override
        public final Builder mouthOpen(MouthOpen mouthOpen) {
            this.mouthOpen = mouthOpen;
            return this;
        }

        public final void setMouthOpen(MouthOpen mouthOpen) {
            this.mouthOpen = mouthOpen;
        }

        public final Collection<Emotion> getEmotions() {
            return this.emotions;
        }

        @Override
        public final Builder emotions(Collection<Emotion> emotions) {
            this.emotions = EmotionsCopier.copy(emotions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emotions(Emotion ... emotions) {
            if (this.emotions == null) {
                this.emotions = new ArrayList<Emotion>(emotions.length);
            }
            for (Emotion e : emotions) {
                this.emotions.add(e);
            }
            return this;
        }

        public final void setEmotions(Collection<Emotion> emotions) {
            this.emotions = EmotionsCopier.copy(emotions);
        }

        @SafeVarargs
        public final void setEmotions(Emotion ... emotions) {
            if (this.emotions == null) {
                this.emotions = new ArrayList<Emotion>(emotions.length);
            }
            for (Emotion e : emotions) {
                this.emotions.add(e);
            }
        }

        public final Collection<Landmark> getLandmarks() {
            return this.landmarks;
        }

        @Override
        public final Builder landmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder landmarks(Landmark ... landmarks) {
            if (this.landmarks == null) {
                this.landmarks = new ArrayList<Landmark>(landmarks.length);
            }
            for (Landmark e : landmarks) {
                this.landmarks.add(e);
            }
            return this;
        }

        public final void setLandmarks(Collection<Landmark> landmarks) {
            this.landmarks = LandmarksCopier.copy(landmarks);
        }

        @SafeVarargs
        public final void setLandmarks(Landmark ... landmarks) {
            if (this.landmarks == null) {
                this.landmarks = new ArrayList<Landmark>(landmarks.length);
            }
            for (Landmark e : landmarks) {
                this.landmarks.add(e);
            }
        }

        public final Pose getPose() {
            return this.pose;
        }

        @Override
        public final Builder pose(Pose pose) {
            this.pose = pose;
            return this;
        }

        public final void setPose(Pose pose) {
            this.pose = pose;
        }

        public final ImageQuality getQuality() {
            return this.quality;
        }

        @Override
        public final Builder quality(ImageQuality quality) {
            this.quality = quality;
            return this;
        }

        public final void setQuality(ImageQuality quality) {
            this.quality = quality;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public FaceDetail build() {
            return new FaceDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FaceDetail> {
        public Builder boundingBox(BoundingBox var1);

        public Builder ageRange(AgeRange var1);

        public Builder smile(Smile var1);

        public Builder eyeglasses(Eyeglasses var1);

        public Builder sunglasses(Sunglasses var1);

        public Builder gender(Gender var1);

        public Builder beard(Beard var1);

        public Builder mustache(Mustache var1);

        public Builder eyesOpen(EyeOpen var1);

        public Builder mouthOpen(MouthOpen var1);

        public Builder emotions(Collection<Emotion> var1);

        public Builder emotions(Emotion ... var1);

        public Builder landmarks(Collection<Landmark> var1);

        public Builder landmarks(Landmark ... var1);

        public Builder pose(Pose var1);

        public Builder quality(ImageQuality var1);

        public Builder confidence(Float var1);
    }
}

