/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rekognition.model.Image;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DetectModerationLabelsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DetectModerationLabelsRequest> {
    private final Image image;
    private final Float minConfidence;

    private DetectModerationLabelsRequest(BuilderImpl builder) {
        this.image = builder.image;
        this.minConfidence = builder.minConfidence;
    }

    public Image image() {
        return this.image;
    }

    public Float minConfidence() {
        return this.minConfidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.image() == null ? 0 : this.image().hashCode());
        hashCode = 31 * hashCode + (this.minConfidence() == null ? 0 : this.minConfidence().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsRequest)) {
            return false;
        }
        DetectModerationLabelsRequest other = (DetectModerationLabelsRequest)((Object)obj);
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.minConfidence() == null ^ this.minConfidence() == null) {
            return false;
        }
        return other.minConfidence() == null || other.minConfidence().equals(this.minConfidence());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.image() != null) {
            sb.append("Image: ").append(this.image()).append(",");
        }
        if (this.minConfidence() != null) {
            sb.append("MinConfidence: ").append(this.minConfidence()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Image image;
        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsRequest model) {
            this.setImage(model.image);
            this.setMinConfidence(model.minConfidence);
        }

        public final Image getImage() {
            return this.image;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image image) {
            this.image = image;
        }

        public final Float getMinConfidence() {
            return this.minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        public DetectModerationLabelsRequest build() {
            return new DetectModerationLabelsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DetectModerationLabelsRequest> {
        public Builder image(Image var1);

        public Builder minConfidence(Float var1);
    }
}

