/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rekognition.model.FaceIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteFacesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteFacesRequest> {
    private final String collectionId;
    private final List<String> faceIds;

    private DeleteFacesRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.faceIds = builder.faceIds;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public List<String> faceIds() {
        return this.faceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.collectionId() == null ? 0 : this.collectionId().hashCode());
        hashCode = 31 * hashCode + (this.faceIds() == null ? 0 : this.faceIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFacesRequest)) {
            return false;
        }
        DeleteFacesRequest other = (DeleteFacesRequest)((Object)obj);
        if (other.collectionId() == null ^ this.collectionId() == null) {
            return false;
        }
        if (other.collectionId() != null && !other.collectionId().equals(this.collectionId())) {
            return false;
        }
        if (other.faceIds() == null ^ this.faceIds() == null) {
            return false;
        }
        return other.faceIds() == null || other.faceIds().equals(this.faceIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.collectionId() != null) {
            sb.append("CollectionId: ").append(this.collectionId()).append(",");
        }
        if (this.faceIds() != null) {
            sb.append("FaceIds: ").append(this.faceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String collectionId;
        private List<String> faceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFacesRequest model) {
            this.setCollectionId(model.collectionId);
            this.setFaceIds(model.faceIds);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Collection<String> getFaceIds() {
            return this.faceIds;
        }

        @Override
        public final Builder faceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceIds(String ... faceIds) {
            if (this.faceIds == null) {
                this.faceIds = new ArrayList<String>(faceIds.length);
            }
            for (String e : faceIds) {
                this.faceIds.add(e);
            }
            return this;
        }

        public final void setFaceIds(Collection<String> faceIds) {
            this.faceIds = FaceIdListCopier.copy(faceIds);
        }

        @SafeVarargs
        public final void setFaceIds(String ... faceIds) {
            if (this.faceIds == null) {
                this.faceIds = new ArrayList<String>(faceIds.length);
            }
            for (String e : faceIds) {
                this.faceIds.add(e);
            }
        }

        public DeleteFacesRequest build() {
            return new DeleteFacesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteFacesRequest> {
        public Builder collectionId(String var1);

        public Builder faceIds(Collection<String> var1);

        public Builder faceIds(String ... var1);
    }
}

