/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.ModerationLabelMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a single type of moderated content found in an image. Each type of moderated content has a
 * label within a hierarchical taxonomy. For more information, see <a>image-moderation</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModerationLabel implements StructuredPojo, ToCopyableBuilder<ModerationLabel.Builder, ModerationLabel> {
    private final Float confidence;

    private final String name;

    private final String parentName;

    private ModerationLabel(BuilderImpl builder) {
        this.confidence = builder.confidence;
        this.name = builder.name;
        this.parentName = builder.parentName;
    }

    /**
     * <p>
     * Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.
     * </p>
     * <p>
     * If you don't specify the <code>MinConfidence</code> parameter in the call to <code>DetectModerationLabels</code>,
     * the operation returns labels with a confidence value greater than or equal to 50 percent.
     * </p>
     * 
     * @return Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p>
     *         <p>
     *         If you don't specify the <code>MinConfidence</code> parameter in the call to
     *         <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or
     *         equal to 50 percent.
     */
    public Float confidence() {
        return confidence;
    }

    /**
     * <p>
     * The label name for the type of content detected in the image.
     * </p>
     * 
     * @return The label name for the type of content detected in the image.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name for the parent label. Labels at the top-level of the hierarchy have the parent label <code>""</code>.
     * </p>
     * 
     * @return The name for the parent label. Labels at the top-level of the hierarchy have the parent label
     *         <code>""</code>.
     */
    public String parentName() {
        return parentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((confidence() == null) ? 0 : confidence().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((parentName() == null) ? 0 : parentName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModerationLabel)) {
            return false;
        }
        ModerationLabel other = (ModerationLabel) obj;
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        if (other.confidence() != null && !other.confidence().equals(this.confidence())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.parentName() == null ^ this.parentName() == null) {
            return false;
        }
        if (other.parentName() != null && !other.parentName().equals(this.parentName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (confidence() != null) {
            sb.append("Confidence: ").append(confidence()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (parentName() != null) {
            sb.append("ParentName: ").append(parentName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ModerationLabelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ModerationLabel> {
        /**
         * <p>
         * Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.
         * </p>
         * <p>
         * If you don't specify the <code>MinConfidence</code> parameter in the call to
         * <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than or
         * equal to 50 percent.
         * </p>
         * 
         * @param confidence
         *        Specifies the confidence that Amazon Rekognition has that the label has been correctly identified.</p>
         *        <p>
         *        If you don't specify the <code>MinConfidence</code> parameter in the call to
         *        <code>DetectModerationLabels</code>, the operation returns labels with a confidence value greater than
         *        or equal to 50 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);

        /**
         * <p>
         * The label name for the type of content detected in the image.
         * </p>
         * 
         * @param name
         *        The label name for the type of content detected in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name for the parent label. Labels at the top-level of the hierarchy have the parent label <code>""</code>
         * .
         * </p>
         * 
         * @param parentName
         *        The name for the parent label. Labels at the top-level of the hierarchy have the parent label
         *        <code>""</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentName(String parentName);
    }

    private static final class BuilderImpl implements Builder {
        private Float confidence;

        private String name;

        private String parentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModerationLabel model) {
            setConfidence(model.confidence);
            setName(model.name);
            setParentName(model.parentName);
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getParentName() {
            return parentName;
        }

        @Override
        public final Builder parentName(String parentName) {
            this.parentName = parentName;
            return this;
        }

        public final void setParentName(String parentName) {
            this.parentName = parentName;
        }

        @Override
        public ModerationLabel build() {
            return new ModerationLabel(this);
        }
    }
}
