/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DetectModerationLabelsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DetectModerationLabelsRequest.Builder, DetectModerationLabelsRequest> {
    private final Image image;

    private final Float minConfidence;

    private DetectModerationLabelsRequest(BuilderImpl builder) {
        this.image = builder.image;
        this.minConfidence = builder.minConfidence;
    }

    /**
     * <p>
     * The input image as bytes or an S3 object.
     * </p>
     * 
     * @return The input image as bytes or an S3 object.
     */
    public Image image() {
        return image;
    }

    /**
     * <p>
     * Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels
     * with a confidence level lower than this specified value.
     * </p>
     * <p>
     * If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values greater than
     * or equal to 50 percent.
     * </p>
     * 
     * @return Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any
     *         labels with a confidence level lower than this specified value.</p>
     *         <p>
     *         If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values
     *         greater than or equal to 50 percent.
     */
    public Float minConfidence() {
        return minConfidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((image() == null) ? 0 : image().hashCode());
        hashCode = 31 * hashCode + ((minConfidence() == null) ? 0 : minConfidence().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectModerationLabelsRequest)) {
            return false;
        }
        DetectModerationLabelsRequest other = (DetectModerationLabelsRequest) obj;
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.minConfidence() == null ^ this.minConfidence() == null) {
            return false;
        }
        if (other.minConfidence() != null && !other.minConfidence().equals(this.minConfidence())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (minConfidence() != null) {
            sb.append("MinConfidence: ").append(minConfidence()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DetectModerationLabelsRequest> {
        /**
         * <p>
         * The input image as bytes or an S3 object.
         * </p>
         * 
         * @param image
         *        The input image as bytes or an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any labels
         * with a confidence level lower than this specified value.
         * </p>
         * <p>
         * If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values greater
         * than or equal to 50 percent.
         * </p>
         * 
         * @param minConfidence
         *        Specifies the minimum confidence level for the labels to return. Amazon Rekognition doesn't return any
         *        labels with a confidence level lower than this specified value.</p>
         *        <p>
         *        If you don't specify <code>MinConfidence</code>, the operation returns labels with confidence values
         *        greater than or equal to 50 percent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minConfidence(Float minConfidence);
    }

    private static final class BuilderImpl implements Builder {
        private Image image;

        private Float minConfidence;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectModerationLabelsRequest model) {
            setImage(model.image);
            setMinConfidence(model.minConfidence);
        }

        public final Image getImage() {
            return image;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image image) {
            this.image = image;
        }

        public final Float getMinConfidence() {
            return minConfidence;
        }

        @Override
        public final Builder minConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
            return this;
        }

        public final void setMinConfidence(Float minConfidence) {
            this.minConfidence = minConfidence;
        }

        @Override
        public DetectModerationLabelsRequest build() {
            return new DetectModerationLabelsRequest(this);
        }
    }
}
