/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.internal.util;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.utils.OptionalUtils;

@SdkInternalApi
public final class Ec2MetadataDisableV1Resolver {
    private Ec2MetadataDisableV1Resolver() {
    }

    public static Ec2MetadataDisableV1Resolver create() {
        return new Ec2MetadataDisableV1Resolver();
    }

    public boolean resolve() {
        return OptionalUtils.firstPresent(Ec2MetadataDisableV1Resolver.fromSystemSettings(), (Supplier[])new Supplier[]{Ec2MetadataDisableV1Resolver::fromProfileFile}).orElse(false);
    }

    private static Optional<Boolean> fromSystemSettings() {
        return SdkSystemSetting.AWS_EC2_METADATA_V1_DISABLED.getBooleanValue();
    }

    private static Optional<Boolean> fromProfileFile() {
        Supplier<ProfileFile> profileFile = ProfileFile::defaultProfileFile;
        String profileName = ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
        if (profileFile.get() == null) {
            return Optional.empty();
        }
        return profileFile.get().profile(profileName).flatMap(p -> p.property("ec2_metadata_v1_disabled")).map(Ec2MetadataDisableV1Resolver::safeProfileStringToBoolean);
    }

    private static boolean safeProfileStringToBoolean(String value) {
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalStateException("Profile property 'ec2_metadata_v1_disabled', was defined as '" + value + "', but should be 'false' or 'true'");
    }
}

