/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.model.EndpointAccess;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse;

public class ListEndpointAccessPublisher
implements SdkPublisher<ListEndpointAccessResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListEndpointAccessRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEndpointAccessPublisher(RedshiftServerlessAsyncClient client, ListEndpointAccessRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEndpointAccessPublisher(RedshiftServerlessAsyncClient client, ListEndpointAccessRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEndpointAccessResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEndpointAccessResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EndpointAccess> endpoints() {
        Function<ListEndpointAccessResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEndpointAccessResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEndpointAccessResponseFetcher
    implements AsyncPageFetcher<ListEndpointAccessResponse> {
        private ListEndpointAccessResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointAccessResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEndpointAccessResponse> nextPage(ListEndpointAccessResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointAccessPublisher.this.client.listEndpointAccess(ListEndpointAccessPublisher.this.firstRequest);
            }
            return ListEndpointAccessPublisher.this.client.listEndpointAccess((ListEndpointAccessRequest)((Object)ListEndpointAccessPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

