/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessClient;
import software.amazon.awssdk.services.redshiftserverless.model.EndpointAccess;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListEndpointAccessResponse;

public class ListEndpointAccessIterable
implements SdkIterable<ListEndpointAccessResponse> {
    private final RedshiftServerlessClient client;
    private final ListEndpointAccessRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEndpointAccessIterable(RedshiftServerlessClient client, ListEndpointAccessRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEndpointAccessResponseFetcher();
    }

    public Iterator<ListEndpointAccessResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EndpointAccess> endpoints() {
        Function<ListEndpointAccessResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEndpointAccessResponseFetcher
    implements SyncPageFetcher<ListEndpointAccessResponse> {
        private ListEndpointAccessResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointAccessResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEndpointAccessResponse nextPage(ListEndpointAccessResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointAccessIterable.this.client.listEndpointAccess(ListEndpointAccessIterable.this.firstRequest);
            }
            return ListEndpointAccessIterable.this.client.listEndpointAccess((ListEndpointAccessRequest)((Object)ListEndpointAccessIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

