/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeferredMaintenanceWindow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeferredMaintenanceWindow> {
    private static final SdkField<String> DEFER_MAINTENANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeferredMaintenanceWindow.getter(DeferredMaintenanceWindow::deferMaintenanceIdentifier)).setter(DeferredMaintenanceWindow.setter(Builder::deferMaintenanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceIdentifier").build()}).build();
    private static final SdkField<Instant> DEFER_MAINTENANCE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DeferredMaintenanceWindow.getter(DeferredMaintenanceWindow::deferMaintenanceStartTime)).setter(DeferredMaintenanceWindow.setter(Builder::deferMaintenanceStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceStartTime").build()}).build();
    private static final SdkField<Instant> DEFER_MAINTENANCE_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DeferredMaintenanceWindow.getter(DeferredMaintenanceWindow::deferMaintenanceEndTime)).setter(DeferredMaintenanceWindow.setter(Builder::deferMaintenanceEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferMaintenanceEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFER_MAINTENANCE_IDENTIFIER_FIELD, DEFER_MAINTENANCE_START_TIME_FIELD, DEFER_MAINTENANCE_END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deferMaintenanceIdentifier;
    private final Instant deferMaintenanceStartTime;
    private final Instant deferMaintenanceEndTime;

    private DeferredMaintenanceWindow(BuilderImpl builder) {
        this.deferMaintenanceIdentifier = builder.deferMaintenanceIdentifier;
        this.deferMaintenanceStartTime = builder.deferMaintenanceStartTime;
        this.deferMaintenanceEndTime = builder.deferMaintenanceEndTime;
    }

    public String deferMaintenanceIdentifier() {
        return this.deferMaintenanceIdentifier;
    }

    public Instant deferMaintenanceStartTime() {
        return this.deferMaintenanceStartTime;
    }

    public Instant deferMaintenanceEndTime() {
        return this.deferMaintenanceEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deferMaintenanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deferMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deferMaintenanceEndTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeferredMaintenanceWindow)) {
            return false;
        }
        DeferredMaintenanceWindow other = (DeferredMaintenanceWindow)obj;
        return Objects.equals(this.deferMaintenanceIdentifier(), other.deferMaintenanceIdentifier()) && Objects.equals(this.deferMaintenanceStartTime(), other.deferMaintenanceStartTime()) && Objects.equals(this.deferMaintenanceEndTime(), other.deferMaintenanceEndTime());
    }

    public String toString() {
        return ToString.builder((String)"DeferredMaintenanceWindow").add("DeferMaintenanceIdentifier", (Object)this.deferMaintenanceIdentifier()).add("DeferMaintenanceStartTime", (Object)this.deferMaintenanceStartTime()).add("DeferMaintenanceEndTime", (Object)this.deferMaintenanceEndTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeferMaintenanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.deferMaintenanceIdentifier()));
            }
            case "DeferMaintenanceStartTime": {
                return Optional.ofNullable(clazz.cast(this.deferMaintenanceStartTime()));
            }
            case "DeferMaintenanceEndTime": {
                return Optional.ofNullable(clazz.cast(this.deferMaintenanceEndTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeferredMaintenanceWindow, T> g) {
        return obj -> g.apply((DeferredMaintenanceWindow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deferMaintenanceIdentifier;
        private Instant deferMaintenanceStartTime;
        private Instant deferMaintenanceEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeferredMaintenanceWindow model) {
            this.deferMaintenanceIdentifier(model.deferMaintenanceIdentifier);
            this.deferMaintenanceStartTime(model.deferMaintenanceStartTime);
            this.deferMaintenanceEndTime(model.deferMaintenanceEndTime);
        }

        public final String getDeferMaintenanceIdentifier() {
            return this.deferMaintenanceIdentifier;
        }

        @Override
        public final Builder deferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
            return this;
        }

        public final void setDeferMaintenanceIdentifier(String deferMaintenanceIdentifier) {
            this.deferMaintenanceIdentifier = deferMaintenanceIdentifier;
        }

        public final Instant getDeferMaintenanceStartTime() {
            return this.deferMaintenanceStartTime;
        }

        @Override
        public final Builder deferMaintenanceStartTime(Instant deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
            return this;
        }

        public final void setDeferMaintenanceStartTime(Instant deferMaintenanceStartTime) {
            this.deferMaintenanceStartTime = deferMaintenanceStartTime;
        }

        public final Instant getDeferMaintenanceEndTime() {
            return this.deferMaintenanceEndTime;
        }

        @Override
        public final Builder deferMaintenanceEndTime(Instant deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
            return this;
        }

        public final void setDeferMaintenanceEndTime(Instant deferMaintenanceEndTime) {
            this.deferMaintenanceEndTime = deferMaintenanceEndTime;
        }

        public DeferredMaintenanceWindow build() {
            return new DeferredMaintenanceWindow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeferredMaintenanceWindow> {
        public Builder deferMaintenanceIdentifier(String var1);

        public Builder deferMaintenanceStartTime(Instant var1);

        public Builder deferMaintenanceEndTime(Instant var1);
    }
}

