/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a recurring charge.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecurringCharge implements SdkPojo, Serializable, ToCopyableBuilder<RecurringCharge.Builder, RecurringCharge> {
    private static final SdkField<Double> RECURRING_CHARGE_AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(RecurringCharge::recurringChargeAmount)).setter(setter(Builder::recurringChargeAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringChargeAmount").build())
            .build();

    private static final SdkField<String> RECURRING_CHARGE_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RecurringCharge::recurringChargeFrequency)).setter(setter(Builder::recurringChargeFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringChargeFrequency").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECURRING_CHARGE_AMOUNT_FIELD,
            RECURRING_CHARGE_FREQUENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double recurringChargeAmount;

    private final String recurringChargeFrequency;

    private RecurringCharge(BuilderImpl builder) {
        this.recurringChargeAmount = builder.recurringChargeAmount;
        this.recurringChargeFrequency = builder.recurringChargeFrequency;
    }

    /**
     * <p>
     * The amount charged per the period of time specified by the recurring charge frequency.
     * </p>
     * 
     * @return The amount charged per the period of time specified by the recurring charge frequency.
     */
    public Double recurringChargeAmount() {
        return recurringChargeAmount;
    }

    /**
     * <p>
     * The frequency at which the recurring charge amount is applied.
     * </p>
     * 
     * @return The frequency at which the recurring charge amount is applied.
     */
    public String recurringChargeFrequency() {
        return recurringChargeFrequency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recurringChargeAmount());
        hashCode = 31 * hashCode + Objects.hashCode(recurringChargeFrequency());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge) obj;
        return Objects.equals(recurringChargeAmount(), other.recurringChargeAmount())
                && Objects.equals(recurringChargeFrequency(), other.recurringChargeFrequency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RecurringCharge").add("RecurringChargeAmount", recurringChargeAmount())
                .add("RecurringChargeFrequency", recurringChargeFrequency()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecurringChargeAmount":
            return Optional.ofNullable(clazz.cast(recurringChargeAmount()));
        case "RecurringChargeFrequency":
            return Optional.ofNullable(clazz.cast(recurringChargeFrequency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecurringCharge, T> g) {
        return obj -> g.apply((RecurringCharge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecurringCharge> {
        /**
         * <p>
         * The amount charged per the period of time specified by the recurring charge frequency.
         * </p>
         * 
         * @param recurringChargeAmount
         *        The amount charged per the period of time specified by the recurring charge frequency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringChargeAmount(Double recurringChargeAmount);

        /**
         * <p>
         * The frequency at which the recurring charge amount is applied.
         * </p>
         * 
         * @param recurringChargeFrequency
         *        The frequency at which the recurring charge amount is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringChargeFrequency(String recurringChargeFrequency);
    }

    static final class BuilderImpl implements Builder {
        private Double recurringChargeAmount;

        private String recurringChargeFrequency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringCharge model) {
            recurringChargeAmount(model.recurringChargeAmount);
            recurringChargeFrequency(model.recurringChargeFrequency);
        }

        public final Double getRecurringChargeAmount() {
            return recurringChargeAmount;
        }

        @Override
        public final Builder recurringChargeAmount(Double recurringChargeAmount) {
            this.recurringChargeAmount = recurringChargeAmount;
            return this;
        }

        public final void setRecurringChargeAmount(Double recurringChargeAmount) {
            this.recurringChargeAmount = recurringChargeAmount;
        }

        public final String getRecurringChargeFrequency() {
            return recurringChargeFrequency;
        }

        @Override
        public final Builder recurringChargeFrequency(String recurringChargeFrequency) {
            this.recurringChargeFrequency = recurringChargeFrequency;
            return this;
        }

        public final void setRecurringChargeFrequency(String recurringChargeFrequency) {
            this.recurringChargeFrequency = recurringChargeFrequency;
        }

        @Override
        public RecurringCharge build() {
            return new RecurringCharge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
