/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySnapshotScheduleRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifySnapshotScheduleRequest.Builder, ModifySnapshotScheduleRequest> {
    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifySnapshotScheduleRequest::scheduleIdentifier)).setter(setter(Builder::scheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build())
            .build();

    private static final SdkField<List<String>> SCHEDULE_DEFINITIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifySnapshotScheduleRequest::scheduleDefinitions))
            .setter(setter(Builder::scheduleDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ScheduleDefinition")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ScheduleDefinition").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_IDENTIFIER_FIELD,
            SCHEDULE_DEFINITIONS_FIELD));

    private final String scheduleIdentifier;

    private final List<String> scheduleDefinitions;

    private ModifySnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.scheduleDefinitions = builder.scheduleDefinitions;
    }

    /**
     * <p>
     * A unique alphanumeric identifier of the schedule to modify.
     * </p>
     * 
     * @return A unique alphanumeric identifier of the schedule to modify.
     */
    public String scheduleIdentifier() {
        return scheduleIdentifier;
    }

    /**
     * <p>
     * An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for example,
     * "cron(30 12 *)" or "rate(12 hours)".
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for
     *         example, "cron(30 12 *)" or "rate(12 hours)".
     */
    public List<String> scheduleDefinitions() {
        return scheduleDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleDefinitions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotScheduleRequest)) {
            return false;
        }
        ModifySnapshotScheduleRequest other = (ModifySnapshotScheduleRequest) obj;
        return Objects.equals(scheduleIdentifier(), other.scheduleIdentifier())
                && Objects.equals(scheduleDefinitions(), other.scheduleDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifySnapshotScheduleRequest").add("ScheduleIdentifier", scheduleIdentifier())
                .add("ScheduleDefinitions", scheduleDefinitions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(scheduleIdentifier()));
        case "ScheduleDefinitions":
            return Optional.ofNullable(clazz.cast(scheduleDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotScheduleRequest, T> g) {
        return obj -> g.apply((ModifySnapshotScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifySnapshotScheduleRequest> {
        /**
         * <p>
         * A unique alphanumeric identifier of the schedule to modify.
         * </p>
         * 
         * @param scheduleIdentifier
         *        A unique alphanumeric identifier of the schedule to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleIdentifier(String scheduleIdentifier);

        /**
         * <p>
         * An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for
         * example, "cron(30 12 *)" or "rate(12 hours)".
         * </p>
         * 
         * @param scheduleDefinitions
         *        An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for
         *        example, "cron(30 12 *)" or "rate(12 hours)".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleDefinitions(Collection<String> scheduleDefinitions);

        /**
         * <p>
         * An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for
         * example, "cron(30 12 *)" or "rate(12 hours)".
         * </p>
         * 
         * @param scheduleDefinitions
         *        An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for
         *        example, "cron(30 12 *)" or "rate(12 hours)".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleDefinitions(String... scheduleDefinitions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String scheduleIdentifier;

        private List<String> scheduleDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotScheduleRequest model) {
            super(model);
            scheduleIdentifier(model.scheduleIdentifier);
            scheduleDefinitions(model.scheduleDefinitions);
        }

        public final String getScheduleIdentifier() {
            return scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        public final Collection<String> getScheduleDefinitions() {
            return scheduleDefinitions;
        }

        @Override
        public final Builder scheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleDefinitions(String... scheduleDefinitions) {
            scheduleDefinitions(Arrays.asList(scheduleDefinitions));
            return this;
        }

        public final void setScheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotScheduleRequest build() {
            return new ModifySnapshotScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
