/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservedNodeExchangeOfferingsResponse extends RedshiftResponse implements
        ToCopyableBuilder<GetReservedNodeExchangeOfferingsResponse.Builder, GetReservedNodeExchangeOfferingsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetReservedNodeExchangeOfferingsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReservedNodeOffering>> RESERVED_NODE_OFFERINGS_FIELD = SdkField
            .<List<ReservedNodeOffering>> builder(MarshallingType.LIST)
            .getter(getter(GetReservedNodeExchangeOfferingsResponse::reservedNodeOfferings))
            .setter(setter(Builder::reservedNodeOfferings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedNodeOffering")
                            .memberFieldInfo(
                                    SdkField.<ReservedNodeOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedNodeOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedNodeOffering").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            RESERVED_NODE_OFFERINGS_FIELD));

    private final String marker;

    private final List<ReservedNodeOffering> reservedNodeOfferings;

    private GetReservedNodeExchangeOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedNodeOfferings = builder.reservedNodeOfferings;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point for returning a set of response records. When the results
     * of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords, Amazon
     * Redshift returns a value in the marker field of the response. You can retrieve the next set of response records
     * by providing the returned marker value in the marker parameter and retrying the request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point for returning a set of response records. When the
     *         results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in
     *         MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the
     *         next set of response records by providing the returned marker value in the marker parameter and retrying
     *         the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Returns an array of <a>ReservedNodeOffering</a> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns an array of <a>ReservedNodeOffering</a> objects.
     */
    public List<ReservedNodeOffering> reservedNodeOfferings() {
        return reservedNodeOfferings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeOfferings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservedNodeExchangeOfferingsResponse)) {
            return false;
        }
        GetReservedNodeExchangeOfferingsResponse other = (GetReservedNodeExchangeOfferingsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(reservedNodeOfferings(), other.reservedNodeOfferings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetReservedNodeExchangeOfferingsResponse").add("Marker", marker())
                .add("ReservedNodeOfferings", reservedNodeOfferings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReservedNodeOfferings":
            return Optional.ofNullable(clazz.cast(reservedNodeOfferings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservedNodeExchangeOfferingsResponse, T> g) {
        return obj -> g.apply((GetReservedNodeExchangeOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservedNodeExchangeOfferingsResponse> {
        /**
         * <p>
         * An optional parameter that specifies the starting point for returning a set of response records. When the
         * results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords,
         * Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of
         * response records by providing the returned marker value in the marker parameter and retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point for returning a set of response records. When
         *        the results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in
         *        MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the
         *        next set of response records by providing the returned marker value in the marker parameter and
         *        retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns an array of <a>ReservedNodeOffering</a> objects.
         * </p>
         * 
         * @param reservedNodeOfferings
         *        Returns an array of <a>ReservedNodeOffering</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeOfferings(Collection<ReservedNodeOffering> reservedNodeOfferings);

        /**
         * <p>
         * Returns an array of <a>ReservedNodeOffering</a> objects.
         * </p>
         * 
         * @param reservedNodeOfferings
         *        Returns an array of <a>ReservedNodeOffering</a> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeOfferings(ReservedNodeOffering... reservedNodeOfferings);

        /**
         * <p>
         * Returns an array of <a>ReservedNodeOffering</a> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedNodeOffering>.Builder} avoiding the
         * need to create one manually via {@link List<ReservedNodeOffering>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedNodeOffering>.Builder#build()} is called immediately
         * and its result is passed to {@link #reservedNodeOfferings(List<ReservedNodeOffering>)}.
         * 
         * @param reservedNodeOfferings
         *        a consumer that will call methods on {@link List<ReservedNodeOffering>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedNodeOfferings(List<ReservedNodeOffering>)
         */
        Builder reservedNodeOfferings(Consumer<ReservedNodeOffering.Builder>... reservedNodeOfferings);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReservedNodeOffering> reservedNodeOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservedNodeExchangeOfferingsResponse model) {
            super(model);
            marker(model.marker);
            reservedNodeOfferings(model.reservedNodeOfferings);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedNodeOffering.Builder> getReservedNodeOfferings() {
            return reservedNodeOfferings != null ? reservedNodeOfferings.stream().map(ReservedNodeOffering::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedNodeOfferings(Collection<ReservedNodeOffering> reservedNodeOfferings) {
            this.reservedNodeOfferings = ReservedNodeOfferingListCopier.copy(reservedNodeOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeOfferings(ReservedNodeOffering... reservedNodeOfferings) {
            reservedNodeOfferings(Arrays.asList(reservedNodeOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeOfferings(Consumer<ReservedNodeOffering.Builder>... reservedNodeOfferings) {
            reservedNodeOfferings(Stream.of(reservedNodeOfferings)
                    .map(c -> ReservedNodeOffering.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedNodeOfferings(Collection<ReservedNodeOffering.BuilderImpl> reservedNodeOfferings) {
            this.reservedNodeOfferings = ReservedNodeOfferingListCopier.copyFromBuilder(reservedNodeOfferings);
        }

        @Override
        public GetReservedNodeExchangeOfferingsResponse build() {
            return new GetReservedNodeExchangeOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
