/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDefaultClusterParametersResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeDefaultClusterParametersResponse.Builder, DescribeDefaultClusterParametersResponse> {
    private static final SdkField<DefaultClusterParameters> DEFAULT_CLUSTER_PARAMETERS_FIELD = SdkField
            .<DefaultClusterParameters> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeDefaultClusterParametersResponse::defaultClusterParameters))
            .setter(setter(Builder::defaultClusterParameters)).constructor(DefaultClusterParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultClusterParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DEFAULT_CLUSTER_PARAMETERS_FIELD));

    private final DefaultClusterParameters defaultClusterParameters;

    private DescribeDefaultClusterParametersResponse(BuilderImpl builder) {
        super(builder);
        this.defaultClusterParameters = builder.defaultClusterParameters;
    }

    /**
     * Returns the value of the DefaultClusterParameters property for this object.
     * 
     * @return The value of the DefaultClusterParameters property for this object.
     */
    public DefaultClusterParameters defaultClusterParameters() {
        return defaultClusterParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(defaultClusterParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDefaultClusterParametersResponse)) {
            return false;
        }
        DescribeDefaultClusterParametersResponse other = (DescribeDefaultClusterParametersResponse) obj;
        return Objects.equals(defaultClusterParameters(), other.defaultClusterParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDefaultClusterParametersResponse")
                .add("DefaultClusterParameters", defaultClusterParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultClusterParameters":
            return Optional.ofNullable(clazz.cast(defaultClusterParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDefaultClusterParametersResponse, T> g) {
        return obj -> g.apply((DescribeDefaultClusterParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDefaultClusterParametersResponse> {
        /**
         * Sets the value of the DefaultClusterParameters property for this object.
         *
         * @param defaultClusterParameters
         *        The new value for the DefaultClusterParameters property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultClusterParameters(DefaultClusterParameters defaultClusterParameters);

        /**
         * Sets the value of the DefaultClusterParameters property for this object.
         *
         * This is a convenience that creates an instance of the {@link DefaultClusterParameters.Builder} avoiding the
         * need to create one manually via {@link DefaultClusterParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefaultClusterParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #defaultClusterParameters(DefaultClusterParameters)}.
         * 
         * @param defaultClusterParameters
         *        a consumer that will call methods on {@link DefaultClusterParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultClusterParameters(DefaultClusterParameters)
         */
        default Builder defaultClusterParameters(Consumer<DefaultClusterParameters.Builder> defaultClusterParameters) {
            return defaultClusterParameters(DefaultClusterParameters.builder().applyMutation(defaultClusterParameters).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private DefaultClusterParameters defaultClusterParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDefaultClusterParametersResponse model) {
            super(model);
            defaultClusterParameters(model.defaultClusterParameters);
        }

        public final DefaultClusterParameters.Builder getDefaultClusterParameters() {
            return defaultClusterParameters != null ? defaultClusterParameters.toBuilder() : null;
        }

        @Override
        public final Builder defaultClusterParameters(DefaultClusterParameters defaultClusterParameters) {
            this.defaultClusterParameters = defaultClusterParameters;
            return this;
        }

        public final void setDefaultClusterParameters(DefaultClusterParameters.BuilderImpl defaultClusterParameters) {
            this.defaultClusterParameters = defaultClusterParameters != null ? defaultClusterParameters.build() : null;
        }

        @Override
        public DescribeDefaultClusterParametersResponse build() {
            return new DescribeDefaultClusterParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
