/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterSecurityGroupsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterSecurityGroupsResponse.Builder, DescribeClusterSecurityGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClusterSecurityGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ClusterSecurityGroup>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField
            .<List<ClusterSecurityGroup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeClusterSecurityGroupsResponse::clusterSecurityGroups))
            .setter(setter(Builder::clusterSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterSecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<ClusterSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterSecurityGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CLUSTER_SECURITY_GROUPS_FIELD));

    private final String marker;

    private final List<ClusterSecurityGroup> clusterSecurityGroups;

    private DescribeClusterSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A list of <a>ClusterSecurityGroup</a> instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a>ClusterSecurityGroup</a> instances.
     */
    public List<ClusterSecurityGroup> clusterSecurityGroups() {
        return clusterSecurityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSecurityGroupsResponse)) {
            return false;
        }
        DescribeClusterSecurityGroupsResponse other = (DescribeClusterSecurityGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(clusterSecurityGroups(), other.clusterSecurityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClusterSecurityGroupsResponse").add("Marker", marker())
                .add("ClusterSecurityGroups", clusterSecurityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ClusterSecurityGroups":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSecurityGroupsResponse, T> g) {
        return obj -> g.apply((DescribeClusterSecurityGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterSecurityGroupsResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <a>ClusterSecurityGroup</a> instances.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of <a>ClusterSecurityGroup</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(Collection<ClusterSecurityGroup> clusterSecurityGroups);

        /**
         * <p>
         * A list of <a>ClusterSecurityGroup</a> instances.
         * </p>
         * 
         * @param clusterSecurityGroups
         *        A list of <a>ClusterSecurityGroup</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroups(ClusterSecurityGroup... clusterSecurityGroups);

        /**
         * <p>
         * A list of <a>ClusterSecurityGroup</a> instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterSecurityGroup>.Builder} avoiding the
         * need to create one manually via {@link List<ClusterSecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterSecurityGroup>.Builder#build()} is called immediately
         * and its result is passed to {@link #clusterSecurityGroups(List<ClusterSecurityGroup>)}.
         * 
         * @param clusterSecurityGroups
         *        a consumer that will call methods on {@link List<ClusterSecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSecurityGroups(List<ClusterSecurityGroup>)
         */
        Builder clusterSecurityGroups(Consumer<ClusterSecurityGroup.Builder>... clusterSecurityGroups);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ClusterSecurityGroup> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSecurityGroupsResponse model) {
            super(model);
            marker(model.marker);
            clusterSecurityGroups(model.clusterSecurityGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterSecurityGroup.Builder> getClusterSecurityGroups() {
            return clusterSecurityGroups != null ? clusterSecurityGroups.stream().map(ClusterSecurityGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<ClusterSecurityGroup> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupsCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(ClusterSecurityGroup... clusterSecurityGroups) {
            clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(Consumer<ClusterSecurityGroup.Builder>... clusterSecurityGroups) {
            clusterSecurityGroups(Stream.of(clusterSecurityGroups)
                    .map(c -> ClusterSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<ClusterSecurityGroup.BuilderImpl> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupsCopier.copyFromBuilder(clusterSecurityGroups);
        }

        @Override
        public DescribeClusterSecurityGroupsResponse build() {
            return new DescribeClusterSecurityGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
