/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSnapshotScheduleRequest extends RedshiftRequest implements
        ToCopyableBuilder<DeleteSnapshotScheduleRequest.Builder, DeleteSnapshotScheduleRequest> {
    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteSnapshotScheduleRequest::scheduleIdentifier)).setter(setter(Builder::scheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_IDENTIFIER_FIELD));

    private final String scheduleIdentifier;

    private DeleteSnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.scheduleIdentifier = builder.scheduleIdentifier;
    }

    /**
     * <p>
     * A unique identifier of the snapshot schedule to delete.
     * </p>
     * 
     * @return A unique identifier of the snapshot schedule to delete.
     */
    public String scheduleIdentifier() {
        return scheduleIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduleIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSnapshotScheduleRequest)) {
            return false;
        }
        DeleteSnapshotScheduleRequest other = (DeleteSnapshotScheduleRequest) obj;
        return Objects.equals(scheduleIdentifier(), other.scheduleIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteSnapshotScheduleRequest").add("ScheduleIdentifier", scheduleIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(scheduleIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSnapshotScheduleRequest, T> g) {
        return obj -> g.apply((DeleteSnapshotScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSnapshotScheduleRequest> {
        /**
         * <p>
         * A unique identifier of the snapshot schedule to delete.
         * </p>
         * 
         * @param scheduleIdentifier
         *        A unique identifier of the snapshot schedule to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleIdentifier(String scheduleIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String scheduleIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSnapshotScheduleRequest model) {
            super(model);
            scheduleIdentifier(model.scheduleIdentifier);
        }

        public final String getScheduleIdentifier() {
            return scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSnapshotScheduleRequest build() {
            return new DeleteSnapshotScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
