/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHsmConfigurationRequest extends RedshiftRequest implements
        ToCopyableBuilder<CreateHsmConfigurationRequest.Builder, CreateHsmConfigurationRequest> {
    private static final SdkField<String> HSM_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHsmConfigurationRequest::hsmConfigurationIdentifier))
            .setter(setter(Builder::hsmConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurationIdentifier").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHsmConfigurationRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> HSM_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHsmConfigurationRequest::hsmIpAddress)).setter(setter(Builder::hsmIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmIpAddress").build()).build();

    private static final SdkField<String> HSM_PARTITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHsmConfigurationRequest::hsmPartitionName)).setter(setter(Builder::hsmPartitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmPartitionName").build()).build();

    private static final SdkField<String> HSM_PARTITION_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHsmConfigurationRequest::hsmPartitionPassword)).setter(setter(Builder::hsmPartitionPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmPartitionPassword").build())
            .build();

    private static final SdkField<String> HSM_SERVER_PUBLIC_CERTIFICATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateHsmConfigurationRequest::hsmServerPublicCertificate))
            .setter(setter(Builder::hsmServerPublicCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmServerPublicCertificate").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateHsmConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HSM_CONFIGURATION_IDENTIFIER_FIELD, DESCRIPTION_FIELD, HSM_IP_ADDRESS_FIELD, HSM_PARTITION_NAME_FIELD,
            HSM_PARTITION_PASSWORD_FIELD, HSM_SERVER_PUBLIC_CERTIFICATE_FIELD, TAGS_FIELD));

    private final String hsmConfigurationIdentifier;

    private final String description;

    private final String hsmIpAddress;

    private final String hsmPartitionName;

    private final String hsmPartitionPassword;

    private final String hsmServerPublicCertificate;

    private final List<Tag> tags;

    private CreateHsmConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.description = builder.description;
        this.hsmIpAddress = builder.hsmIpAddress;
        this.hsmPartitionName = builder.hsmPartitionName;
        this.hsmPartitionPassword = builder.hsmPartitionPassword;
        this.hsmServerPublicCertificate = builder.hsmServerPublicCertificate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier to be assigned to the new Amazon Redshift HSM configuration.
     * </p>
     * 
     * @return The identifier to be assigned to the new Amazon Redshift HSM configuration.
     */
    public String hsmConfigurationIdentifier() {
        return hsmConfigurationIdentifier;
    }

    /**
     * <p>
     * A text description of the HSM configuration to be created.
     * </p>
     * 
     * @return A text description of the HSM configuration to be created.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The IP address that the Amazon Redshift cluster must use to access the HSM.
     * </p>
     * 
     * @return The IP address that the Amazon Redshift cluster must use to access the HSM.
     */
    public String hsmIpAddress() {
        return hsmIpAddress;
    }

    /**
     * <p>
     * The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption
     * keys.
     * </p>
     * 
     * @return The name of the partition in the HSM where the Amazon Redshift clusters will store their database
     *         encryption keys.
     */
    public String hsmPartitionName() {
        return hsmPartitionName;
    }

    /**
     * <p>
     * The password required to access the HSM partition.
     * </p>
     * 
     * @return The password required to access the HSM partition.
     */
    public String hsmPartitionPassword() {
        return hsmPartitionPassword;
    }

    /**
     * <p>
     * The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
     * </p>
     * 
     * @return The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
     */
    public String hsmServerPublicCertificate() {
        return hsmServerPublicCertificate;
    }

    /**
     * <p>
     * A list of tag instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of tag instances.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hsmIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hsmPartitionName());
        hashCode = 31 * hashCode + Objects.hashCode(hsmPartitionPassword());
        hashCode = 31 * hashCode + Objects.hashCode(hsmServerPublicCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmConfigurationRequest)) {
            return false;
        }
        CreateHsmConfigurationRequest other = (CreateHsmConfigurationRequest) obj;
        return Objects.equals(hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier())
                && Objects.equals(description(), other.description()) && Objects.equals(hsmIpAddress(), other.hsmIpAddress())
                && Objects.equals(hsmPartitionName(), other.hsmPartitionName())
                && Objects.equals(hsmPartitionPassword(), other.hsmPartitionPassword())
                && Objects.equals(hsmServerPublicCertificate(), other.hsmServerPublicCertificate())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateHsmConfigurationRequest").add("HsmConfigurationIdentifier", hsmConfigurationIdentifier())
                .add("Description", description()).add("HsmIpAddress", hsmIpAddress())
                .add("HsmPartitionName", hsmPartitionName()).add("HsmPartitionPassword", hsmPartitionPassword())
                .add("HsmServerPublicCertificate", hsmServerPublicCertificate()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HsmConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(hsmConfigurationIdentifier()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "HsmIpAddress":
            return Optional.ofNullable(clazz.cast(hsmIpAddress()));
        case "HsmPartitionName":
            return Optional.ofNullable(clazz.cast(hsmPartitionName()));
        case "HsmPartitionPassword":
            return Optional.ofNullable(clazz.cast(hsmPartitionPassword()));
        case "HsmServerPublicCertificate":
            return Optional.ofNullable(clazz.cast(hsmServerPublicCertificate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHsmConfigurationRequest, T> g) {
        return obj -> g.apply((CreateHsmConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateHsmConfigurationRequest> {
        /**
         * <p>
         * The identifier to be assigned to the new Amazon Redshift HSM configuration.
         * </p>
         * 
         * @param hsmConfigurationIdentifier
         *        The identifier to be assigned to the new Amazon Redshift HSM configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier);

        /**
         * <p>
         * A text description of the HSM configuration to be created.
         * </p>
         * 
         * @param description
         *        A text description of the HSM configuration to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IP address that the Amazon Redshift cluster must use to access the HSM.
         * </p>
         * 
         * @param hsmIpAddress
         *        The IP address that the Amazon Redshift cluster must use to access the HSM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmIpAddress(String hsmIpAddress);

        /**
         * <p>
         * The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption
         * keys.
         * </p>
         * 
         * @param hsmPartitionName
         *        The name of the partition in the HSM where the Amazon Redshift clusters will store their database
         *        encryption keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmPartitionName(String hsmPartitionName);

        /**
         * <p>
         * The password required to access the HSM partition.
         * </p>
         * 
         * @param hsmPartitionPassword
         *        The password required to access the HSM partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmPartitionPassword(String hsmPartitionPassword);

        /**
         * <p>
         * The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
         * </p>
         * 
         * @param hsmServerPublicCertificate
         *        The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmServerPublicCertificate(String hsmServerPublicCertificate);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * 
         * @param tags
         *        A list of tag instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * 
         * @param tags
         *        A list of tag instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tag instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String hsmConfigurationIdentifier;

        private String description;

        private String hsmIpAddress;

        private String hsmPartitionName;

        private String hsmPartitionPassword;

        private String hsmServerPublicCertificate;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmConfigurationRequest model) {
            super(model);
            hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            description(model.description);
            hsmIpAddress(model.hsmIpAddress);
            hsmPartitionName(model.hsmPartitionName);
            hsmPartitionPassword(model.hsmPartitionPassword);
            hsmServerPublicCertificate(model.hsmServerPublicCertificate);
            tags(model.tags);
        }

        public final String getHsmConfigurationIdentifier() {
            return hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHsmIpAddress() {
            return hsmIpAddress;
        }

        @Override
        public final Builder hsmIpAddress(String hsmIpAddress) {
            this.hsmIpAddress = hsmIpAddress;
            return this;
        }

        public final void setHsmIpAddress(String hsmIpAddress) {
            this.hsmIpAddress = hsmIpAddress;
        }

        public final String getHsmPartitionName() {
            return hsmPartitionName;
        }

        @Override
        public final Builder hsmPartitionName(String hsmPartitionName) {
            this.hsmPartitionName = hsmPartitionName;
            return this;
        }

        public final void setHsmPartitionName(String hsmPartitionName) {
            this.hsmPartitionName = hsmPartitionName;
        }

        public final String getHsmPartitionPassword() {
            return hsmPartitionPassword;
        }

        @Override
        public final Builder hsmPartitionPassword(String hsmPartitionPassword) {
            this.hsmPartitionPassword = hsmPartitionPassword;
            return this;
        }

        public final void setHsmPartitionPassword(String hsmPartitionPassword) {
            this.hsmPartitionPassword = hsmPartitionPassword;
        }

        public final String getHsmServerPublicCertificate() {
            return hsmServerPublicCertificate;
        }

        @Override
        public final Builder hsmServerPublicCertificate(String hsmServerPublicCertificate) {
            this.hsmServerPublicCertificate = hsmServerPublicCertificate;
            return this;
        }

        public final void setHsmServerPublicCertificate(String hsmServerPublicCertificate) {
            this.hsmServerPublicCertificate = hsmServerPublicCertificate;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHsmConfigurationRequest build() {
            return new CreateHsmConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
