/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterSubnetGroupResponse extends RedshiftResponse implements
        ToCopyableBuilder<CreateClusterSubnetGroupResponse.Builder, CreateClusterSubnetGroupResponse> {
    private static final SdkField<ClusterSubnetGroup> CLUSTER_SUBNET_GROUP_FIELD = SdkField
            .<ClusterSubnetGroup> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateClusterSubnetGroupResponse::clusterSubnetGroup)).setter(setter(Builder::clusterSubnetGroup))
            .constructor(ClusterSubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroup").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SUBNET_GROUP_FIELD));

    private final ClusterSubnetGroup clusterSubnetGroup;

    private CreateClusterSubnetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.clusterSubnetGroup = builder.clusterSubnetGroup;
    }

    /**
     * Returns the value of the ClusterSubnetGroup property for this object.
     * 
     * @return The value of the ClusterSubnetGroup property for this object.
     */
    public ClusterSubnetGroup clusterSubnetGroup() {
        return clusterSubnetGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterSubnetGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterSubnetGroupResponse)) {
            return false;
        }
        CreateClusterSubnetGroupResponse other = (CreateClusterSubnetGroupResponse) obj;
        return Objects.equals(clusterSubnetGroup(), other.clusterSubnetGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateClusterSubnetGroupResponse").add("ClusterSubnetGroup", clusterSubnetGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSubnetGroup":
            return Optional.ofNullable(clazz.cast(clusterSubnetGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterSubnetGroupResponse, T> g) {
        return obj -> g.apply((CreateClusterSubnetGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateClusterSubnetGroupResponse> {
        /**
         * Sets the value of the ClusterSubnetGroup property for this object.
         *
         * @param clusterSubnetGroup
         *        The new value for the ClusterSubnetGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSubnetGroup(ClusterSubnetGroup clusterSubnetGroup);

        /**
         * Sets the value of the ClusterSubnetGroup property for this object.
         *
         * This is a convenience that creates an instance of the {@link ClusterSubnetGroup.Builder} avoiding the need to
         * create one manually via {@link ClusterSubnetGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClusterSubnetGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #clusterSubnetGroup(ClusterSubnetGroup)}.
         * 
         * @param clusterSubnetGroup
         *        a consumer that will call methods on {@link ClusterSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterSubnetGroup(ClusterSubnetGroup)
         */
        default Builder clusterSubnetGroup(Consumer<ClusterSubnetGroup.Builder> clusterSubnetGroup) {
            return clusterSubnetGroup(ClusterSubnetGroup.builder().applyMutation(clusterSubnetGroup).build());
        }
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private ClusterSubnetGroup clusterSubnetGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterSubnetGroupResponse model) {
            super(model);
            clusterSubnetGroup(model.clusterSubnetGroup);
        }

        public final ClusterSubnetGroup.Builder getClusterSubnetGroup() {
            return clusterSubnetGroup != null ? clusterSubnetGroup.toBuilder() : null;
        }

        @Override
        public final Builder clusterSubnetGroup(ClusterSubnetGroup clusterSubnetGroup) {
            this.clusterSubnetGroup = clusterSubnetGroup;
            return this;
        }

        public final void setClusterSubnetGroup(ClusterSubnetGroup.BuilderImpl clusterSubnetGroup) {
            this.clusterSubnetGroup = clusterSubnetGroup != null ? clusterSubnetGroup.build() : null;
        }

        @Override
        public CreateClusterSubnetGroupResponse build() {
            return new CreateClusterSubnetGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
