/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSecurityGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterSecurityGroup.Builder, ClusterSecurityGroup> {
    private static final SdkField<String> CLUSTER_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterSecurityGroup::clusterSecurityGroupName)).setter(setter(Builder::clusterSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroupName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterSecurityGroup::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<EC2SecurityGroup>> EC2_SECURITY_GROUPS_FIELD = SdkField
            .<List<EC2SecurityGroup>> builder(MarshallingType.LIST)
            .getter(getter(ClusterSecurityGroup::ec2SecurityGroups))
            .setter(setter(Builder::ec2SecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EC2SecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<EC2SecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2SecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EC2SecurityGroup").build()).build()).build()).build();

    private static final SdkField<List<IPRange>> IP_RANGES_FIELD = SdkField
            .<List<IPRange>> builder(MarshallingType.LIST)
            .getter(getter(ClusterSecurityGroup::ipRanges))
            .setter(setter(Builder::ipRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IPRange")
                            .memberFieldInfo(
                                    SdkField.<IPRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IPRange").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ClusterSecurityGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SECURITY_GROUP_NAME_FIELD, DESCRIPTION_FIELD, EC2_SECURITY_GROUPS_FIELD, IP_RANGES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterSecurityGroupName;

    private final String description;

    private final List<EC2SecurityGroup> ec2SecurityGroups;

    private final List<IPRange> ipRanges;

    private final List<Tag> tags;

    private ClusterSecurityGroup(BuilderImpl builder) {
        this.clusterSecurityGroupName = builder.clusterSecurityGroupName;
        this.description = builder.description;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.ipRanges = builder.ipRanges;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the cluster security group to which the operation was applied.
     * </p>
     * 
     * @return The name of the cluster security group to which the operation was applied.
     */
    public String clusterSecurityGroupName() {
        return clusterSecurityGroupName;
    }

    /**
     * <p>
     * A description of the security group.
     * </p>
     * 
     * @return A description of the security group.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A list of EC2 security groups that are permitted to access clusters associated with this cluster security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of EC2 security groups that are permitted to access clusters associated with this cluster security
     *         group.
     */
    public List<EC2SecurityGroup> ec2SecurityGroups() {
        return ec2SecurityGroups;
    }

    /**
     * <p>
     * A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security
     * group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster
     *         security group.
     */
    public List<IPRange> ipRanges() {
        return ipRanges;
    }

    /**
     * <p>
     * The list of tags for the cluster security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of tags for the cluster security group.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(ipRanges());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSecurityGroup)) {
            return false;
        }
        ClusterSecurityGroup other = (ClusterSecurityGroup) obj;
        return Objects.equals(clusterSecurityGroupName(), other.clusterSecurityGroupName())
                && Objects.equals(description(), other.description())
                && Objects.equals(ec2SecurityGroups(), other.ec2SecurityGroups()) && Objects.equals(ipRanges(), other.ipRanges())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClusterSecurityGroup").add("ClusterSecurityGroupName", clusterSecurityGroupName())
                .add("Description", description()).add("EC2SecurityGroups", ec2SecurityGroups()).add("IPRanges", ipRanges())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSecurityGroupName":
            return Optional.ofNullable(clazz.cast(clusterSecurityGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EC2SecurityGroups":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroups()));
        case "IPRanges":
            return Optional.ofNullable(clazz.cast(ipRanges()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSecurityGroup, T> g) {
        return obj -> g.apply((ClusterSecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSecurityGroup> {
        /**
         * <p>
         * The name of the cluster security group to which the operation was applied.
         * </p>
         * 
         * @param clusterSecurityGroupName
         *        The name of the cluster security group to which the operation was applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSecurityGroupName(String clusterSecurityGroupName);

        /**
         * <p>
         * A description of the security group.
         * </p>
         * 
         * @param description
         *        A description of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of EC2 security groups that are permitted to access clusters associated with this cluster security
         * group.
         * </p>
         * 
         * @param ec2SecurityGroups
         *        A list of EC2 security groups that are permitted to access clusters associated with this cluster
         *        security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups);

        /**
         * <p>
         * A list of EC2 security groups that are permitted to access clusters associated with this cluster security
         * group.
         * </p>
         * 
         * @param ec2SecurityGroups
         *        A list of EC2 security groups that are permitted to access clusters associated with this cluster
         *        security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroups(EC2SecurityGroup... ec2SecurityGroups);

        /**
         * <p>
         * A list of EC2 security groups that are permitted to access clusters associated with this cluster security
         * group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EC2SecurityGroup>.Builder} avoiding the
         * need to create one manually via {@link List<EC2SecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EC2SecurityGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2SecurityGroups(List<EC2SecurityGroup>)}.
         * 
         * @param ec2SecurityGroups
         *        a consumer that will call methods on {@link List<EC2SecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2SecurityGroups(List<EC2SecurityGroup>)
         */
        Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder>... ec2SecurityGroups);

        /**
         * <p>
         * A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security
         * group.
         * </p>
         * 
         * @param ipRanges
         *        A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster
         *        security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(Collection<IPRange> ipRanges);

        /**
         * <p>
         * A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security
         * group.
         * </p>
         * 
         * @param ipRanges
         *        A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster
         *        security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(IPRange... ipRanges);

        /**
         * <p>
         * A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security
         * group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IPRange>.Builder} avoiding the need to
         * create one manually via {@link List<IPRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IPRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipRanges(List<IPRange>)}.
         * 
         * @param ipRanges
         *        a consumer that will call methods on {@link List<IPRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipRanges(List<IPRange>)
         */
        Builder ipRanges(Consumer<IPRange.Builder>... ipRanges);

        /**
         * <p>
         * The list of tags for the cluster security group.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags for the cluster security group.
         * </p>
         * 
         * @param tags
         *        The list of tags for the cluster security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags for the cluster security group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String clusterSecurityGroupName;

        private String description;

        private List<EC2SecurityGroup> ec2SecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<IPRange> ipRanges = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSecurityGroup model) {
            clusterSecurityGroupName(model.clusterSecurityGroupName);
            description(model.description);
            ec2SecurityGroups(model.ec2SecurityGroups);
            ipRanges(model.ipRanges);
            tags(model.tags);
        }

        public final String getClusterSecurityGroupName() {
            return clusterSecurityGroupName;
        }

        @Override
        public final Builder clusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        public final void setClusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<EC2SecurityGroup.Builder> getEc2SecurityGroups() {
            return ec2SecurityGroups != null ? ec2SecurityGroups.stream().map(EC2SecurityGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup... ec2SecurityGroups) {
            ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder>... ec2SecurityGroups) {
            ec2SecurityGroups(Stream.of(ec2SecurityGroups).map(c -> EC2SecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEc2SecurityGroups(Collection<EC2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copyFromBuilder(ec2SecurityGroups);
        }

        public final Collection<IPRange.Builder> getIpRanges() {
            return ipRanges != null ? ipRanges.stream().map(IPRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(IPRange... ipRanges) {
            ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(Consumer<IPRange.Builder>... ipRanges) {
            ipRanges(Stream.of(ipRanges).map(c -> IPRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpRanges(Collection<IPRange.BuilderImpl> ipRanges) {
            this.ipRanges = IPRangeListCopier.copyFromBuilder(ipRanges);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public ClusterSecurityGroup build() {
            return new ClusterSecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
