/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identifier of a node in a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterNode implements SdkPojo, Serializable, ToCopyableBuilder<ClusterNode.Builder, ClusterNode> {
    private static final SdkField<String> NODE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterNode::nodeRole)).setter(setter(Builder::nodeRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRole").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterNode::privateIPAddress)).setter(setter(Builder::privateIPAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIPAddress").build()).build();

    private static final SdkField<String> PUBLIC_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterNode::publicIPAddress)).setter(setter(Builder::publicIPAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIPAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ROLE_FIELD,
            PRIVATE_IP_ADDRESS_FIELD, PUBLIC_IP_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nodeRole;

    private final String privateIPAddress;

    private final String publicIPAddress;

    private ClusterNode(BuilderImpl builder) {
        this.nodeRole = builder.nodeRole;
        this.privateIPAddress = builder.privateIPAddress;
        this.publicIPAddress = builder.publicIPAddress;
    }

    /**
     * <p>
     * Whether the node is a leader node or a compute node.
     * </p>
     * 
     * @return Whether the node is a leader node or a compute node.
     */
    public String nodeRole() {
        return nodeRole;
    }

    /**
     * <p>
     * The private IP address of a node within a cluster.
     * </p>
     * 
     * @return The private IP address of a node within a cluster.
     */
    public String privateIPAddress() {
        return privateIPAddress;
    }

    /**
     * <p>
     * The public IP address of a node within a cluster.
     * </p>
     * 
     * @return The public IP address of a node within a cluster.
     */
    public String publicIPAddress() {
        return publicIPAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeRole());
        hashCode = 31 * hashCode + Objects.hashCode(privateIPAddress());
        hashCode = 31 * hashCode + Objects.hashCode(publicIPAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode other = (ClusterNode) obj;
        return Objects.equals(nodeRole(), other.nodeRole()) && Objects.equals(privateIPAddress(), other.privateIPAddress())
                && Objects.equals(publicIPAddress(), other.publicIPAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClusterNode").add("NodeRole", nodeRole()).add("PrivateIPAddress", privateIPAddress())
                .add("PublicIPAddress", publicIPAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeRole":
            return Optional.ofNullable(clazz.cast(nodeRole()));
        case "PrivateIPAddress":
            return Optional.ofNullable(clazz.cast(privateIPAddress()));
        case "PublicIPAddress":
            return Optional.ofNullable(clazz.cast(publicIPAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterNode, T> g) {
        return obj -> g.apply((ClusterNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterNode> {
        /**
         * <p>
         * Whether the node is a leader node or a compute node.
         * </p>
         * 
         * @param nodeRole
         *        Whether the node is a leader node or a compute node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeRole(String nodeRole);

        /**
         * <p>
         * The private IP address of a node within a cluster.
         * </p>
         * 
         * @param privateIPAddress
         *        The private IP address of a node within a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIPAddress(String privateIPAddress);

        /**
         * <p>
         * The public IP address of a node within a cluster.
         * </p>
         * 
         * @param publicIPAddress
         *        The public IP address of a node within a cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIPAddress(String publicIPAddress);
    }

    static final class BuilderImpl implements Builder {
        private String nodeRole;

        private String privateIPAddress;

        private String publicIPAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNode model) {
            nodeRole(model.nodeRole);
            privateIPAddress(model.privateIPAddress);
            publicIPAddress(model.publicIPAddress);
        }

        public final String getNodeRole() {
            return nodeRole;
        }

        @Override
        public final Builder nodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
            return this;
        }

        public final void setNodeRole(String nodeRole) {
            this.nodeRole = nodeRole;
        }

        public final String getPrivateIPAddress() {
            return privateIPAddress;
        }

        @Override
        public final Builder privateIPAddress(String privateIPAddress) {
            this.privateIPAddress = privateIPAddress;
            return this;
        }

        public final void setPrivateIPAddress(String privateIPAddress) {
            this.privateIPAddress = privateIPAddress;
        }

        public final String getPublicIPAddress() {
            return publicIPAddress;
        }

        @Override
        public final Builder publicIPAddress(String publicIPAddress) {
            this.publicIPAddress = publicIPAddress;
            return this;
        }

        public final void setPublicIPAddress(String publicIPAddress) {
            this.publicIPAddress = publicIPAddress;
        }

        @Override
        public ClusterNode build() {
            return new ClusterNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
