/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedNodeExchangeStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedNodeExchangeStatus> {
    private static final SdkField<String> RESERVED_NODE_EXCHANGE_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodeExchangeRequestId").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::reservedNodeExchangeRequestId)).setter(ReservedNodeExchangeStatus.setter(Builder::reservedNodeExchangeRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeExchangeRequestId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::statusAsString)).setter(ReservedNodeExchangeStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestTime").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::requestTime)).setter(ReservedNodeExchangeStatus.setter(Builder::requestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()}).build();
    private static final SdkField<String> SOURCE_RESERVED_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceReservedNodeId").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::sourceReservedNodeId)).setter(ReservedNodeExchangeStatus.setter(Builder::sourceReservedNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceReservedNodeId").build()}).build();
    private static final SdkField<String> SOURCE_RESERVED_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceReservedNodeType").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::sourceReservedNodeType)).setter(ReservedNodeExchangeStatus.setter(Builder::sourceReservedNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceReservedNodeType").build()}).build();
    private static final SdkField<Integer> SOURCE_RESERVED_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SourceReservedNodeCount").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::sourceReservedNodeCount)).setter(ReservedNodeExchangeStatus.setter(Builder::sourceReservedNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceReservedNodeCount").build()}).build();
    private static final SdkField<String> TARGET_RESERVED_NODE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetReservedNodeOfferingId").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::targetReservedNodeOfferingId)).setter(ReservedNodeExchangeStatus.setter(Builder::targetReservedNodeOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOfferingId").build()}).build();
    private static final SdkField<String> TARGET_RESERVED_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetReservedNodeType").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::targetReservedNodeType)).setter(ReservedNodeExchangeStatus.setter(Builder::targetReservedNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeType").build()}).build();
    private static final SdkField<Integer> TARGET_RESERVED_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetReservedNodeCount").getter(ReservedNodeExchangeStatus.getter(ReservedNodeExchangeStatus::targetReservedNodeCount)).setter(ReservedNodeExchangeStatus.setter(Builder::targetReservedNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODE_EXCHANGE_REQUEST_ID_FIELD, STATUS_FIELD, REQUEST_TIME_FIELD, SOURCE_RESERVED_NODE_ID_FIELD, SOURCE_RESERVED_NODE_TYPE_FIELD, SOURCE_RESERVED_NODE_COUNT_FIELD, TARGET_RESERVED_NODE_OFFERING_ID_FIELD, TARGET_RESERVED_NODE_TYPE_FIELD, TARGET_RESERVED_NODE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedNodeExchangeStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reservedNodeExchangeRequestId;
    private final String status;
    private final Instant requestTime;
    private final String sourceReservedNodeId;
    private final String sourceReservedNodeType;
    private final Integer sourceReservedNodeCount;
    private final String targetReservedNodeOfferingId;
    private final String targetReservedNodeType;
    private final Integer targetReservedNodeCount;

    private ReservedNodeExchangeStatus(BuilderImpl builder) {
        this.reservedNodeExchangeRequestId = builder.reservedNodeExchangeRequestId;
        this.status = builder.status;
        this.requestTime = builder.requestTime;
        this.sourceReservedNodeId = builder.sourceReservedNodeId;
        this.sourceReservedNodeType = builder.sourceReservedNodeType;
        this.sourceReservedNodeCount = builder.sourceReservedNodeCount;
        this.targetReservedNodeOfferingId = builder.targetReservedNodeOfferingId;
        this.targetReservedNodeType = builder.targetReservedNodeType;
        this.targetReservedNodeCount = builder.targetReservedNodeCount;
    }

    public final String reservedNodeExchangeRequestId() {
        return this.reservedNodeExchangeRequestId;
    }

    public final ReservedNodeExchangeStatusType status() {
        return ReservedNodeExchangeStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant requestTime() {
        return this.requestTime;
    }

    public final String sourceReservedNodeId() {
        return this.sourceReservedNodeId;
    }

    public final String sourceReservedNodeType() {
        return this.sourceReservedNodeType;
    }

    public final Integer sourceReservedNodeCount() {
        return this.sourceReservedNodeCount;
    }

    public final String targetReservedNodeOfferingId() {
        return this.targetReservedNodeOfferingId;
    }

    public final String targetReservedNodeType() {
        return this.targetReservedNodeType;
    }

    public final Integer targetReservedNodeCount() {
        return this.targetReservedNodeCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeExchangeRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceReservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceReservedNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceReservedNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReservedNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReservedNodeCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNodeExchangeStatus)) {
            return false;
        }
        ReservedNodeExchangeStatus other = (ReservedNodeExchangeStatus)obj;
        return Objects.equals(this.reservedNodeExchangeRequestId(), other.reservedNodeExchangeRequestId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.requestTime(), other.requestTime()) && Objects.equals(this.sourceReservedNodeId(), other.sourceReservedNodeId()) && Objects.equals(this.sourceReservedNodeType(), other.sourceReservedNodeType()) && Objects.equals(this.sourceReservedNodeCount(), other.sourceReservedNodeCount()) && Objects.equals(this.targetReservedNodeOfferingId(), other.targetReservedNodeOfferingId()) && Objects.equals(this.targetReservedNodeType(), other.targetReservedNodeType()) && Objects.equals(this.targetReservedNodeCount(), other.targetReservedNodeCount());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedNodeExchangeStatus").add("ReservedNodeExchangeRequestId", (Object)this.reservedNodeExchangeRequestId()).add("Status", (Object)this.statusAsString()).add("RequestTime", (Object)this.requestTime()).add("SourceReservedNodeId", (Object)this.sourceReservedNodeId()).add("SourceReservedNodeType", (Object)this.sourceReservedNodeType()).add("SourceReservedNodeCount", (Object)this.sourceReservedNodeCount()).add("TargetReservedNodeOfferingId", (Object)this.targetReservedNodeOfferingId()).add("TargetReservedNodeType", (Object)this.targetReservedNodeType()).add("TargetReservedNodeCount", (Object)this.targetReservedNodeCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodeExchangeRequestId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeExchangeRequestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "RequestTime": {
                return Optional.ofNullable(clazz.cast(this.requestTime()));
            }
            case "SourceReservedNodeId": {
                return Optional.ofNullable(clazz.cast(this.sourceReservedNodeId()));
            }
            case "SourceReservedNodeType": {
                return Optional.ofNullable(clazz.cast(this.sourceReservedNodeType()));
            }
            case "SourceReservedNodeCount": {
                return Optional.ofNullable(clazz.cast(this.sourceReservedNodeCount()));
            }
            case "TargetReservedNodeOfferingId": {
                return Optional.ofNullable(clazz.cast(this.targetReservedNodeOfferingId()));
            }
            case "TargetReservedNodeType": {
                return Optional.ofNullable(clazz.cast(this.targetReservedNodeType()));
            }
            case "TargetReservedNodeCount": {
                return Optional.ofNullable(clazz.cast(this.targetReservedNodeCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservedNodeExchangeRequestId", RESERVED_NODE_EXCHANGE_REQUEST_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestTime", REQUEST_TIME_FIELD);
        map.put("SourceReservedNodeId", SOURCE_RESERVED_NODE_ID_FIELD);
        map.put("SourceReservedNodeType", SOURCE_RESERVED_NODE_TYPE_FIELD);
        map.put("SourceReservedNodeCount", SOURCE_RESERVED_NODE_COUNT_FIELD);
        map.put("TargetReservedNodeOfferingId", TARGET_RESERVED_NODE_OFFERING_ID_FIELD);
        map.put("TargetReservedNodeType", TARGET_RESERVED_NODE_TYPE_FIELD);
        map.put("TargetReservedNodeCount", TARGET_RESERVED_NODE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedNodeExchangeStatus, T> g) {
        return obj -> g.apply((ReservedNodeExchangeStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedNodeExchangeRequestId;
        private String status;
        private Instant requestTime;
        private String sourceReservedNodeId;
        private String sourceReservedNodeType;
        private Integer sourceReservedNodeCount;
        private String targetReservedNodeOfferingId;
        private String targetReservedNodeType;
        private Integer targetReservedNodeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNodeExchangeStatus model) {
            this.reservedNodeExchangeRequestId(model.reservedNodeExchangeRequestId);
            this.status(model.status);
            this.requestTime(model.requestTime);
            this.sourceReservedNodeId(model.sourceReservedNodeId);
            this.sourceReservedNodeType(model.sourceReservedNodeType);
            this.sourceReservedNodeCount(model.sourceReservedNodeCount);
            this.targetReservedNodeOfferingId(model.targetReservedNodeOfferingId);
            this.targetReservedNodeType(model.targetReservedNodeType);
            this.targetReservedNodeCount(model.targetReservedNodeCount);
        }

        public final String getReservedNodeExchangeRequestId() {
            return this.reservedNodeExchangeRequestId;
        }

        public final void setReservedNodeExchangeRequestId(String reservedNodeExchangeRequestId) {
            this.reservedNodeExchangeRequestId = reservedNodeExchangeRequestId;
        }

        @Override
        public final Builder reservedNodeExchangeRequestId(String reservedNodeExchangeRequestId) {
            this.reservedNodeExchangeRequestId = reservedNodeExchangeRequestId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReservedNodeExchangeStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getRequestTime() {
            return this.requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final String getSourceReservedNodeId() {
            return this.sourceReservedNodeId;
        }

        public final void setSourceReservedNodeId(String sourceReservedNodeId) {
            this.sourceReservedNodeId = sourceReservedNodeId;
        }

        @Override
        public final Builder sourceReservedNodeId(String sourceReservedNodeId) {
            this.sourceReservedNodeId = sourceReservedNodeId;
            return this;
        }

        public final String getSourceReservedNodeType() {
            return this.sourceReservedNodeType;
        }

        public final void setSourceReservedNodeType(String sourceReservedNodeType) {
            this.sourceReservedNodeType = sourceReservedNodeType;
        }

        @Override
        public final Builder sourceReservedNodeType(String sourceReservedNodeType) {
            this.sourceReservedNodeType = sourceReservedNodeType;
            return this;
        }

        public final Integer getSourceReservedNodeCount() {
            return this.sourceReservedNodeCount;
        }

        public final void setSourceReservedNodeCount(Integer sourceReservedNodeCount) {
            this.sourceReservedNodeCount = sourceReservedNodeCount;
        }

        @Override
        public final Builder sourceReservedNodeCount(Integer sourceReservedNodeCount) {
            this.sourceReservedNodeCount = sourceReservedNodeCount;
            return this;
        }

        public final String getTargetReservedNodeOfferingId() {
            return this.targetReservedNodeOfferingId;
        }

        public final void setTargetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
        }

        @Override
        public final Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
            return this;
        }

        public final String getTargetReservedNodeType() {
            return this.targetReservedNodeType;
        }

        public final void setTargetReservedNodeType(String targetReservedNodeType) {
            this.targetReservedNodeType = targetReservedNodeType;
        }

        @Override
        public final Builder targetReservedNodeType(String targetReservedNodeType) {
            this.targetReservedNodeType = targetReservedNodeType;
            return this;
        }

        public final Integer getTargetReservedNodeCount() {
            return this.targetReservedNodeCount;
        }

        public final void setTargetReservedNodeCount(Integer targetReservedNodeCount) {
            this.targetReservedNodeCount = targetReservedNodeCount;
        }

        @Override
        public final Builder targetReservedNodeCount(Integer targetReservedNodeCount) {
            this.targetReservedNodeCount = targetReservedNodeCount;
            return this;
        }

        public ReservedNodeExchangeStatus build() {
            return new ReservedNodeExchangeStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedNodeExchangeStatus> {
        public Builder reservedNodeExchangeRequestId(String var1);

        public Builder status(String var1);

        public Builder status(ReservedNodeExchangeStatusType var1);

        public Builder requestTime(Instant var1);

        public Builder sourceReservedNodeId(String var1);

        public Builder sourceReservedNodeType(String var1);

        public Builder sourceReservedNodeCount(Integer var1);

        public Builder targetReservedNodeOfferingId(String var1);

        public Builder targetReservedNodeType(String var1);

        public Builder targetReservedNodeCount(Integer var1);
    }
}

