/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RecurringCharge;
import software.amazon.awssdk.services.redshift.model.RecurringChargeListCopier;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedNode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedNode> {
    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodeId").getter(ReservedNode.getter(ReservedNode::reservedNodeId)).setter(ReservedNode.setter(Builder::reservedNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()}).build();
    private static final SdkField<String> RESERVED_NODE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodeOfferingId").getter(ReservedNode.getter(ReservedNode::reservedNodeOfferingId)).setter(ReservedNode.setter(Builder::reservedNodeOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferingId").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(ReservedNode.getter(ReservedNode::nodeType)).setter(ReservedNode.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ReservedNode.getter(ReservedNode::startTime)).setter(ReservedNode.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(ReservedNode.getter(ReservedNode::duration)).setter(ReservedNode.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(ReservedNode.getter(ReservedNode::fixedPrice)).setter(ReservedNode.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UsagePrice").getter(ReservedNode.getter(ReservedNode::usagePrice)).setter(ReservedNode.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(ReservedNode.getter(ReservedNode::currencyCode)).setter(ReservedNode.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NodeCount").getter(ReservedNode.getter(ReservedNode::nodeCount)).setter(ReservedNode.setter(Builder::nodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ReservedNode.getter(ReservedNode::state)).setter(ReservedNode.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(ReservedNode.getter(ReservedNode::offeringType)).setter(ReservedNode.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecurringCharges").getter(ReservedNode.getter(ReservedNode::recurringCharges)).setter(ReservedNode.setter(Builder::recurringCharges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(), ListTrait.builder().memberLocationName("RecurringCharge").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecurringCharge::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharge").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_NODE_OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodeOfferingType").getter(ReservedNode.getter(ReservedNode::reservedNodeOfferingTypeAsString)).setter(ReservedNode.setter(Builder::reservedNodeOfferingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODE_ID_FIELD, RESERVED_NODE_OFFERING_ID_FIELD, NODE_TYPE_FIELD, START_TIME_FIELD, DURATION_FIELD, FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, NODE_COUNT_FIELD, STATE_FIELD, OFFERING_TYPE_FIELD, RECURRING_CHARGES_FIELD, RESERVED_NODE_OFFERING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedNode.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reservedNodeId;
    private final String reservedNodeOfferingId;
    private final String nodeType;
    private final Instant startTime;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final Integer nodeCount;
    private final String state;
    private final String offeringType;
    private final List<RecurringCharge> recurringCharges;
    private final String reservedNodeOfferingType;

    private ReservedNode(BuilderImpl builder) {
        this.reservedNodeId = builder.reservedNodeId;
        this.reservedNodeOfferingId = builder.reservedNodeOfferingId;
        this.nodeType = builder.nodeType;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.nodeCount = builder.nodeCount;
        this.state = builder.state;
        this.offeringType = builder.offeringType;
        this.recurringCharges = builder.recurringCharges;
        this.reservedNodeOfferingType = builder.reservedNodeOfferingType;
    }

    public final String reservedNodeId() {
        return this.reservedNodeId;
    }

    public final String reservedNodeOfferingId() {
        return this.reservedNodeOfferingId;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final Double usagePrice() {
        return this.usagePrice;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer nodeCount() {
        return this.nodeCount;
    }

    public final String state() {
        return this.state;
    }

    public final String offeringType() {
        return this.offeringType;
    }

    public final boolean hasRecurringCharges() {
        return this.recurringCharges != null && !(this.recurringCharges instanceof SdkAutoConstructList);
    }

    public final List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public final ReservedNodeOfferingType reservedNodeOfferingType() {
        return ReservedNodeOfferingType.fromValue(this.reservedNodeOfferingType);
    }

    public final String reservedNodeOfferingTypeAsString() {
        return this.reservedNodeOfferingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecurringCharges() ? this.recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedNode)) {
            return false;
        }
        ReservedNode other = (ReservedNode)obj;
        return Objects.equals(this.reservedNodeId(), other.reservedNodeId()) && Objects.equals(this.reservedNodeOfferingId(), other.reservedNodeOfferingId()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.nodeCount(), other.nodeCount()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.offeringType(), other.offeringType()) && this.hasRecurringCharges() == other.hasRecurringCharges() && Objects.equals(this.recurringCharges(), other.recurringCharges()) && Objects.equals(this.reservedNodeOfferingTypeAsString(), other.reservedNodeOfferingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedNode").add("ReservedNodeId", (Object)this.reservedNodeId()).add("ReservedNodeOfferingId", (Object)this.reservedNodeOfferingId()).add("NodeType", (Object)this.nodeType()).add("StartTime", (Object)this.startTime()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCode()).add("NodeCount", (Object)this.nodeCount()).add("State", (Object)this.state()).add("OfferingType", (Object)this.offeringType()).add("RecurringCharges", this.hasRecurringCharges() ? this.recurringCharges() : null).add("ReservedNodeOfferingType", (Object)this.reservedNodeOfferingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodeId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeId()));
            }
            case "ReservedNodeOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeOfferingId()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "NodeCount": {
                return Optional.ofNullable(clazz.cast(this.nodeCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
            case "ReservedNodeOfferingType": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeOfferingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservedNodeId", RESERVED_NODE_ID_FIELD);
        map.put("ReservedNodeOfferingId", RESERVED_NODE_OFFERING_ID_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("FixedPrice", FIXED_PRICE_FIELD);
        map.put("UsagePrice", USAGE_PRICE_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("NodeCount", NODE_COUNT_FIELD);
        map.put("State", STATE_FIELD);
        map.put("OfferingType", OFFERING_TYPE_FIELD);
        map.put("RecurringCharges", RECURRING_CHARGES_FIELD);
        map.put("ReservedNodeOfferingType", RESERVED_NODE_OFFERING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedNode, T> g) {
        return obj -> g.apply((ReservedNode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedNodeId;
        private String reservedNodeOfferingId;
        private String nodeType;
        private Instant startTime;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private Integer nodeCount;
        private String state;
        private String offeringType;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();
        private String reservedNodeOfferingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedNode model) {
            this.reservedNodeId(model.reservedNodeId);
            this.reservedNodeOfferingId(model.reservedNodeOfferingId);
            this.nodeType(model.nodeType);
            this.startTime(model.startTime);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.nodeCount(model.nodeCount);
            this.state(model.state);
            this.offeringType(model.offeringType);
            this.recurringCharges(model.recurringCharges);
            this.reservedNodeOfferingType(model.reservedNodeOfferingType);
        }

        public final String getReservedNodeId() {
            return this.reservedNodeId;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final String getReservedNodeOfferingId() {
            return this.reservedNodeOfferingId;
        }

        public final void setReservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
        }

        @Override
        public final Builder reservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getNodeCount() {
            return this.nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReservedNodeOfferingType() {
            return this.reservedNodeOfferingType;
        }

        public final void setReservedNodeOfferingType(String reservedNodeOfferingType) {
            this.reservedNodeOfferingType = reservedNodeOfferingType;
        }

        @Override
        public final Builder reservedNodeOfferingType(String reservedNodeOfferingType) {
            this.reservedNodeOfferingType = reservedNodeOfferingType;
            return this;
        }

        @Override
        public final Builder reservedNodeOfferingType(ReservedNodeOfferingType reservedNodeOfferingType) {
            this.reservedNodeOfferingType(reservedNodeOfferingType == null ? null : reservedNodeOfferingType.toString());
            return this;
        }

        public ReservedNode build() {
            return new ReservedNode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedNode> {
        public Builder reservedNodeId(String var1);

        public Builder reservedNodeOfferingId(String var1);

        public Builder nodeType(String var1);

        public Builder startTime(Instant var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder nodeCount(Integer var1);

        public Builder state(String var1);

        public Builder offeringType(String var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);

        public Builder reservedNodeOfferingType(String var1);

        public Builder reservedNodeOfferingType(ReservedNodeOfferingType var1);
    }
}

